/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import com.enderio.core.common.util.PlayerUtil;
import crazypants.enderio.machine.transceiver.ChannelType;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;

public class Channel {
    private final String name;
    final UUID user;
    final ChannelType type;

    public static Channel readFromNBT(NBTTagCompound root) {
        if (!root.hasKey("name")) {
            return null;
        }
        String name = root.getString("name");
        UUID user = null;
        if (root.hasKey("user")) {
            user = PlayerUtil.getPlayerUIDUnstable((String)root.getString("user"));
        }
        ChannelType type = ChannelType.values()[root.getShort("type")];
        return new Channel(name, user, type);
    }

    public Channel(String name, UUID user, ChannelType type) {
        this.name = this.trim(name);
        this.user = user;
        this.type = type;
    }

    public boolean isPublic() {
        return this.user == null;
    }

    public void writeToNBT(NBTTagCompound root) {
        if (this.name == null || this.name.isEmpty()) {
            return;
        }
        root.setString("name", this.name);
        root.setShort("type", (short)this.type.ordinal());
        if (this.user != null) {
            root.setString("user", this.user.toString());
        }
    }

    private String trim(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Channel other = (Channel)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String getName() {
        return this.name;
    }

    public ChannelType getType() {
        return this.type;
    }

    public UUID getUser() {
        return this.user;
    }

    public String toString() {
        return "Channel [name=" + this.name + ", user=" + this.user + ", type=" + (Object)((Object)this.type) + "]";
    }
}

