/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.spawner.ContainerPoweredSpawner;
import crazypants.enderio.machine.spawner.DummyRecipe;
import crazypants.enderio.machine.spawner.GuiPoweredSpawner;
import crazypants.enderio.machine.spawner.ItemBrokenSpawner;
import crazypants.enderio.machine.spawner.PacketMode;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.enderio.machine.spawner.TilePoweredSpawner;
import crazypants.enderio.network.PacketHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;

public class BlockPoweredSpawner
extends AbstractMachineBlock<TilePoweredSpawner>
implements IAdvancedTooltipProvider {
    public static final String KEY_SPAWNED_BY_POWERED_SPAWNER = "spawnedByPoweredSpawner";
    private final List<GameRegistry.UniqueIdentifier> toolBlackList = new ArrayList<GameRegistry.UniqueIdentifier>();
    private Field fieldpersistenceRequired;
    private final Map<BlockCoord, ItemStack> dropCache = new HashMap<BlockCoord, ItemStack>();

    public static void writeMobTypeToNBT(NBTTagCompound nbt, String type) {
        if (nbt == null) {
            return;
        }
        if (type == null) {
            nbt.removeTag("mobType");
        } else {
            nbt.setString("mobType", type);
        }
    }

    public static String readMobTypeFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        if (!nbt.hasKey("mobType")) {
            return null;
        }
        return nbt.getString("mobType");
    }

    public static String getSpawnerTypeFromItemStack(ItemStack stack) {
        if (stack == null || stack.getItem() != Item.getItemFromBlock((Block)EnderIO.blockPoweredSpawner)) {
            return null;
        }
        return BlockPoweredSpawner.readMobTypeFromNBT(stack.stackTagCompound);
    }

    public static BlockPoweredSpawner create() {
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPoweredSpawner.unlocalisedName, new DummyRecipe());
        PacketHandler.INSTANCE.registerMessage(PacketMode.class, PacketMode.class, PacketHandler.nextID(), Side.SERVER);
        PoweredSpawnerConfig.getInstance();
        BlockPoweredSpawner res = new BlockPoweredSpawner();
        MinecraftForge.EVENT_BUS.register((Object)res);
        FMLCommonHandler.instance().bus().register((Object)res);
        res.init();
        return res;
    }

    protected BlockPoweredSpawner() {
        super(ModObject.blockPoweredSpawner, TilePoweredSpawner.class);
        String[] blackListNames;
        for (String name : blackListNames = Config.brokenSpawnerToolBlacklist) {
            this.toolBlackList.add(new GameRegistry.UniqueIdentifier(name));
        }
        try {
            this.fieldpersistenceRequired = ReflectionHelper.findField(EntityLiving.class, (String[])new String[]{"field_82179_bU", "persistenceRequired"});
        }
        catch (Exception e) {
            Log.error("BlockPoweredSpawner: Could not find field: persistenceRequired");
        }
    }

    @SubscribeEvent
    public void onBreakEvent(BlockEvent.BreakEvent evt) {
        if (evt.block instanceof BlockMobSpawner) {
            if (!(evt.getPlayer() == null || evt.getPlayer().capabilities.isCreativeMode || evt.getPlayer().worldObj.isRemote || evt.isCanceled())) {
                TileEntity tile = evt.getPlayer().worldObj.getTileEntity(evt.x, evt.y, evt.z);
                if (tile instanceof TileEntityMobSpawner) {
                    String name;
                    TileEntityMobSpawner spawner;
                    MobSpawnerBaseLogic logic;
                    if (Math.random() > Config.brokenSpawnerDropChance) {
                        return;
                    }
                    ItemStack equipped = evt.getPlayer().getCurrentEquippedItem();
                    if (equipped != null) {
                        for (GameRegistry.UniqueIdentifier uid : this.toolBlackList) {
                            Item blackListItem = GameRegistry.findItem((String)uid.modId, (String)uid.name);
                            if (blackListItem != equipped.getItem()) continue;
                            return;
                        }
                    }
                    if ((logic = (spawner = (TileEntityMobSpawner)tile).func_145881_a()) != null && (name = logic.getEntityNameToSpawn()) != null && !this.isBlackListed(name)) {
                        ItemStack drop = ItemBrokenSpawner.createStackForMobType(name);
                        this.dropCache.put(new BlockCoord(evt.x, evt.y, evt.z), drop);
                        for (int i = (int)(Math.random() * 7.0); i > 0; --i) {
                            logic.spawnDelay = 0;
                            logic.updateSpawner();
                        }
                    }
                }
            } else {
                this.dropCache.put(new BlockCoord(evt.x, evt.y, evt.z), null);
            }
        }
    }

    @SubscribeEvent
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent evt) {
        if (!evt.isCanceled() && evt.block instanceof BlockMobSpawner) {
            BlockCoord bc = new BlockCoord(evt.x, evt.y, evt.z);
            if (this.dropCache.containsKey(bc)) {
                ItemStack stack = this.dropCache.get(bc);
                if (stack != null) {
                    evt.drops.add(stack);
                }
            } else {
                try {
                    for (Object object : evt.world.loadedTileEntityList) {
                        String name;
                        MobSpawnerBaseLogic logic;
                        TileEntityMobSpawner spawner;
                        if (!(object instanceof TileEntityMobSpawner) || (spawner = (TileEntityMobSpawner)object).getWorldObj() != evt.world || spawner.xCoord != evt.x || spawner.yCoord != evt.y || spawner.zCoord != evt.z || (logic = spawner.func_145881_a()) == null || (name = logic.getEntityNameToSpawn()) == null || this.isBlackListed(name)) continue;
                        evt.drops.add(ItemBrokenSpawner.createStackForMobType(name));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.dropCache.clear();
        }
    }

    @SubscribeEvent
    public void handleAnvilEvent(AnvilUpdateEvent evt) {
        if (evt.left == null || evt.left.stackSize != 1 || evt.left.getItem() != Item.getItemFromBlock((Block)EnderIO.blockPoweredSpawner) || evt.right == null || ItemBrokenSpawner.getMobTypeFromStack(evt.right) == null) {
            return;
        }
        String spawnerType = ItemBrokenSpawner.getMobTypeFromStack(evt.right);
        if (this.isBlackListed(spawnerType)) {
            return;
        }
        evt.cost = Config.powerSpawnerAddSpawnerCost;
        evt.output = evt.left.copy();
        if (evt.output.stackTagCompound == null) {
            evt.output.stackTagCompound = new NBTTagCompound();
        }
        evt.output.stackTagCompound.setBoolean("eio.abstractMachine", true);
        BlockPoweredSpawner.writeMobTypeToNBT(evt.output.stackTagCompound, spawnerType);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent livingUpdate) {
        EntityLivingBase ent = livingUpdate.entityLiving;
        if (!ent.getEntityData().hasKey(KEY_SPAWNED_BY_POWERED_SPAWNER)) {
            return;
        }
        if (this.fieldpersistenceRequired == null) {
            ent.getEntityData().removeTag(KEY_SPAWNED_BY_POWERED_SPAWNER);
            return;
        }
        long spawnTime = ent.getEntityData().getLong(KEY_SPAWNED_BY_POWERED_SPAWNER);
        long livedFor = livingUpdate.entity.worldObj.getTotalWorldTime() - spawnTime;
        if (livedFor > (long)(Config.poweredSpawnerDespawnTimeSeconds * 20)) {
            try {
                this.fieldpersistenceRequired.setBoolean(livingUpdate.entityLiving, false);
                ent.getEntityData().removeTag(KEY_SPAWNED_BY_POWERED_SPAWNER);
            }
            catch (Exception e) {
                Log.warn("BlockPoweredSpawner.onLivingUpdate: Error occured allowing entity to despawn: " + e);
                ent.getEntityData().removeTag(KEY_SPAWNED_BY_POWERED_SPAWNER);
            }
        }
    }

    public boolean isBlackListed(String entityId) {
        return PoweredSpawnerConfig.getInstance().isBlackListed(entityId);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TilePoweredSpawner) {
            return new ContainerPoweredSpawner(player.inventory, (TilePoweredSpawner)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TilePoweredSpawner) {
            return new GuiPoweredSpawner(player.inventory, (TilePoweredSpawner)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 88;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:poweredSpawnerFrontActive";
        }
        return "enderio:poweredSpawnerFront";
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String type = BlockPoweredSpawner.getSpawnerTypeFromItemStack(itemstack);
        if (type != null) {
            list.add(StatCollector.translateToLocal((String)("entity." + type + ".name")));
        } else {
            list.add(EnderIO.lang.localizeExact("tile.blockPoweredSpawner.tooltip.empty"));
        }
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        String type = BlockPoweredSpawner.getSpawnerTypeFromItemStack(itemstack);
        if (type == null) {
            SpecialTooltipHandler.addDetailedTooltipFromResources((List)list, (String)"tile.blockPoweredSpawner.empty");
        } else {
            SpecialTooltipHandler.addDetailedTooltipFromResources((List)list, (String)"tile.blockPoweredSpawner");
        }
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TilePoweredSpawner te = (TilePoweredSpawner)world.getTileEntity(x, y, z);
        tooltip.add(te.getEntityName());
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        super.getSubBlocks(item, tab, list);
        list.add(this.createItemStackForMob("Enderman"));
        list.add(this.createItemStackForMob("Chicken"));
    }

    protected ItemStack createItemStackForMob(String mob) {
        ItemStack stack = new ItemStack((Block)this);
        stack.stackTagCompound = new NBTTagCompound();
        stack.stackTagCompound.setBoolean("eio.abstractMachine", true);
        BlockPoweredSpawner.writeMobTypeToNBT(stack.stackTagCompound, mob);
        return stack;
    }

    private static class DropInfo {
        BlockEvent.BreakEvent evt;
        ItemStack drop;

        DropInfo(BlockEvent.BreakEvent evt, ItemStack stack) {
            this.evt = evt;
            this.drop = stack;
        }

        void doDrop() {
            if (this.evt.isCanceled()) {
                return;
            }
            Util.dropItems((World)this.evt.getPlayer().worldObj, (ItemStack)this.drop, (int)this.evt.x, (int)this.evt.y, (int)this.evt.z, (boolean)true);
        }
    }
}

