/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.ClientProxy;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.soul.BlockSoulBinder;
import crazypants.enderio.machine.soul.TileSoulBinder;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class SoulBinderRenderer
implements ISimpleBlockRenderingHandler {
    private float skullScale = 0.5f;
    private BoundingBox scaledBB = BoundingBox.UNIT_CUBE.scale(this.skullScale, this.skullScale, this.skullScale);
    private IIcon[] icons = new IIcon[6];
    private IIcon override = null;

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glDisable((int)2896);
        Tessellator.instance.startDrawingQuads();
        this.renderWorldBlock(null, 0, 0, 0, block, 0, renderer);
        Tessellator.instance.draw();
        GL11.glEnable((int)2896);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        IIcon endermanIcon;
        IIcon soulariumIcon = EnderIO.blockSoulFuser.getIcon(ForgeDirection.EAST.ordinal(), 0);
        this.override = renderer.overrideBlockTexture;
        if (renderer != null && world != null) {
            renderer.setOverrideBlockTexture(IconUtil.blankTexture);
            renderer.renderStandardBlock(Blocks.stone, x, y, z);
            renderer.setOverrideBlockTexture(null);
        }
        Tessellator.instance.addTranslation((float)x, (float)y, (float)z);
        BoundingBox bb = BoundingBox.UNIT_CUBE.scale(0.85, 0.85, 0.85);
        this.setIcons(soulariumIcon, soulariumIcon, ForgeDirection.NORTH);
        CubeRenderer.render((BoundingBox)bb, (IIcon[])this.icons, (boolean)true);
        float slabWidth = 0.15f;
        bb = BoundingBox.UNIT_CUBE.scale(1.0f, slabWidth, 1.0f);
        bb = bb.translate(0.0f, 0.5f - slabWidth / 2.0f, 0.0f);
        this.setIcons(soulariumIcon, EnderIO.blockSoulFuser.getIcon(ForgeDirection.UP.ordinal(), 0), ForgeDirection.UP);
        CubeRenderer.render((BoundingBox)bb, (IIcon[])this.icons, (boolean)true);
        bb = BoundingBox.UNIT_CUBE.scale(1.0f, slabWidth, 1.0f);
        bb = bb.translate(0.0f, -0.5f + slabWidth / 2.0f, 0.0f);
        this.setIcons(soulariumIcon, soulariumIcon, ForgeDirection.NORTH);
        CubeRenderer.render((BoundingBox)bb, (IIcon[])this.icons, (boolean)true);
        int facing = ForgeDirection.SOUTH.ordinal();
        if (world == null || !(world.getTileEntity(x, y, z) instanceof TileSoulBinder)) {
            endermanIcon = EnderIO.blockSoulFuser.endermanSkullIcon;
        } else {
            TileSoulBinder sb = (TileSoulBinder)world.getTileEntity(x, y, z);
            facing = sb.facing;
            endermanIcon = sb.isActive() ? EnderIO.blockSoulFuser.endermanSkullIconOn : EnderIO.blockSoulFuser.endermanSkullIcon;
        }
        this.renderSkull(this.forFacing(ForgeDirection.SOUTH, facing), soulariumIcon, endermanIcon);
        this.renderSkull(this.forFacing(ForgeDirection.WEST, facing), soulariumIcon, EnderIO.blockSoulFuser.skeletonSkullIcon);
        this.renderSkull(this.forFacing(ForgeDirection.NORTH, facing), soulariumIcon, EnderIO.blockSoulFuser.zombieSkullIcon);
        this.renderSkull(this.forFacing(ForgeDirection.EAST, facing), soulariumIcon, EnderIO.blockSoulFuser.creeperSkullIcon);
        Tessellator.instance.addTranslation((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    private ForgeDirection forFacing(ForgeDirection side, int facing) {
        return ForgeDirection.values()[ClientProxy.sideAndFacingToSpriteOffset[side.ordinal()][facing]];
    }

    private void renderSkull(ForgeDirection face, IIcon soulariumIcon, IIcon faceIcon) {
        BoundingBox bb = this.scaledBB.translate(ForgeDirectionOffsets.offsetScaled((ForgeDirection)face, (double)(0.5 - (double)(this.skullScale / 2.0f))));
        this.setIcons(soulariumIcon, faceIcon, face);
        CubeRenderer.render((BoundingBox)bb, (IIcon[])this.icons, (boolean)true);
    }

    private void setIcons(IIcon defaultIcon, IIcon faceIcon, ForgeDirection faceSide) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.icons[dir.ordinal()] = this.override != null ? this.override : (dir == faceSide ? faceIcon : defaultIcon);
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockSoulBinder.renderId;
    }
}

