/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.soul.ContainerSoulBinder;
import crazypants.enderio.machine.soul.GuiSoulBinder;
import crazypants.enderio.machine.soul.TileSoulBinder;
import crazypants.enderio.xp.PacketDrainPlayerXP;
import crazypants.enderio.xp.PacketExperianceContainer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSoulBinder
extends AbstractMachineBlock<TileSoulBinder> {
    public static int renderId;
    IIcon zombieSkullIcon;
    IIcon skeletonSkullIcon;
    IIcon creeperSkullIcon;
    IIcon endermanSkullIcon;
    IIcon endermanSkullIconOn;

    public static BlockSoulBinder create() {
        PacketDrainPlayerXP.register();
        PacketExperianceContainer.register();
        BlockSoulBinder result = new BlockSoulBinder();
        result.init();
        return result;
    }

    protected BlockSoulBinder() {
        super(ModObject.blockSoulBinder, TileSoulBinder.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileSoulBinder) {
            return new ContainerSoulBinder(player.inventory, (TileSoulBinder)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileSoulBinder) {
            return new GuiSoulBinder(player.inventory, (TileSoulBinder)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 93;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getLightOpacity() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        super.registerBlockIcons(iIconRegister);
        this.zombieSkullIcon = iIconRegister.registerIcon("enderio:skullZombie");
        this.creeperSkullIcon = iIconRegister.registerIcon("enderio:skullCreeper");
        this.skeletonSkullIcon = iIconRegister.registerIcon("enderio:skullSkeleton");
        this.endermanSkullIcon = iIconRegister.registerIcon("enderio:endermanSkullFront");
        this.endermanSkullIconOn = iIconRegister.registerIcon("enderio:endermanSkullFrontEyes");
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        return "enderio:blockSoulMachineBlank";
    }

    @Override
    protected String getSideIconKey(boolean active) {
        return "enderio:blockSoulMachineBlank";
    }

    @Override
    protected String getTopIconKey(boolean active) {
        return "enderio:blockSoulMachineTop";
    }

    @Override
    protected String getBottomIconKey(boolean active) {
        return "enderio:blockSoulMachineBottom";
    }

    @Override
    public int getRenderType() {
        return renderId;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (this.isActive((IBlockAccess)world, x, y, z)) {
            float startX = (float)x + 1.0f;
            float startY = (float)y + 1.0f;
            float startZ = (float)z + 1.0f;
            for (int i = 0; i < 2; ++i) {
                float zOffset;
                float yOffset;
                float xOffset = -0.2f - rand.nextFloat() * 0.6f;
                EntityFX fx = Minecraft.getMinecraft().renderGlobal.doSpawnParticle("spell", (double)(startX + xOffset), (double)(startY + (yOffset = -0.1f + rand.nextFloat() * 0.2f)), (double)(startZ + (zOffset = -0.2f - rand.nextFloat() * 0.6f)), 0.0, 0.0, 0.0);
                if (fx == null) continue;
                fx.setRBGColorF(0.2f, 0.2f, 0.8f);
                fx.motionY *= 0.5;
            }
        }
    }
}

