/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.slicensplice;

import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.recipe.ManyToOneMachineRecipe;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class TileSliceAndSplice
extends AbstractPoweredTaskEntity {
    public static final int POWER_PER_TICK_ONE = Config.sliceAndSpliceLevelOnePowerPerTickRF;
    private static final BasicCapacitor CAP_ONE = new BasicCapacitor(POWER_PER_TICK_ONE * 2, Capacitors.BASIC_CAPACITOR.capacitor.getMaxEnergyStored(), POWER_PER_TICK_ONE);
    public static final int POWER_PER_TICK_TWO = Config.sliceAndSpliceLevelTwoPowerPerTickRF;
    private static final BasicCapacitor CAP_TWO = new BasicCapacitor(POWER_PER_TICK_TWO * 2, Capacitors.ACTIVATED_CAPACITOR.capacitor.getMaxEnergyStored(), POWER_PER_TICK_TWO);
    public static final int POWER_PER_TICK_THREE = Config.sliceAndSpliceLevelThreePowerPerTickRF;
    private static final BasicCapacitor CAP_THREE = new BasicCapacitor(POWER_PER_TICK_THREE * 2, Capacitors.ENDER_CAPACITOR.capacitor.getMaxEnergyStored(), POWER_PER_TICK_THREE);
    private final int axeIndex = 6;
    private final int shearsIndex = 7;
    private EntityLivingBase fakePlayer;

    public TileSliceAndSplice() {
        super(new SlotDefinition(8, 1));
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSliceAndSplice.unlocalisedName;
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public void onCapacitorTypeChange() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor(CAP_ONE);
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor(CAP_TWO);
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor(CAP_THREE);
            }
        }
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        if (this.getAxe() == null || this.getShears() == null) {
            return null;
        }
        return super.canStartNextTask(chance);
    }

    private ItemStack getAxe() {
        return this.inventory[6];
    }

    private ItemStack getShears() {
        return this.inventory[7];
    }

    @Override
    protected void taskComplete() {
        super.taskComplete();
        this.damageTool(this.getAxe(), 6);
        this.damageTool(this.getShears(), 7);
    }

    private void damageTool(ItemStack tool, int toolIndex) {
        if (tool != null && tool.isItemStackDamageable()) {
            tool.damageItem(1, this.getFakePlayer());
            if (tool.getItemDamage() >= tool.getMaxDamage()) {
                this.inventory[toolIndex] = null;
            }
        }
    }

    private EntityLivingBase getFakePlayer() {
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)MinecraftServer.getServer().worldServerForDimension(this.worldObj.provider.dimensionId));
        }
        return this.fakePlayer;
    }

    @Override
    protected MachineRecipeInput[] getRecipeInputs() {
        MachineRecipeInput[] res = new MachineRecipeInput[this.slotDefinition.getNumInputSlots() - 2];
        int fromSlot = this.slotDefinition.minInputSlot;
        for (int i = 0; i < res.length; ++i) {
            res[i] = new MachineRecipeInput(fromSlot, this.inventory[fromSlot]);
            ++fromSlot;
        }
        return res;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int slot, ItemStack itemstack) {
        if (itemstack == null || itemstack.getItem() == null) {
            return false;
        }
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        if (slot == 6) {
            return itemstack.getItem() instanceof ItemAxe;
        }
        if (slot == 7) {
            return itemstack.getItem() instanceof ItemShears;
        }
        ItemStack currentStackInSlot = this.inventory[slot];
        if (currentStackInSlot != null) {
            return currentStackInSlot.isItemEqual(itemstack);
        }
        int numSlotsFilled = 0;
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (i < 0 || i >= this.inventory.length || i == 6 || i == 7 || this.inventory[i] == null || this.inventory[i].stackSize <= 0) continue;
            ++numSlotsFilled;
        }
        List<IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForInput(this.getMachineName(), MachineRecipeInput.create(slot, itemstack));
        if (numSlotsFilled == 0 && !recipes.isEmpty()) {
            return true;
        }
        return this.isValidInputForAlloyRecipe(slot, itemstack, numSlotsFilled, recipes);
    }

    private boolean isValidInputForAlloyRecipe(int slot, ItemStack itemstack, int numSlotsFilled, List<IMachineRecipe> recipes) {
        ItemStack[] resultInv = new ItemStack[this.slotDefinition.getNumInputSlots()];
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (i < 0 || i >= this.inventory.length || i == 6 || i == 7) continue;
            resultInv[i] = i == slot ? itemstack : this.inventory[i];
        }
        for (IMachineRecipe recipe : recipes) {
            if (!(recipe instanceof ManyToOneMachineRecipe) || !((ManyToOneMachineRecipe)recipe).isValidRecipeComponents(resultInv)) continue;
            return true;
        }
        return false;
    }

    private boolean isItemAlreadyInASlot(ItemStack itemstack) {
        ItemStack currentStackType = null;
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot() && currentStackType == null; ++i) {
            currentStackType = this.inventory[i];
            if (currentStackType == null || !currentStackType.isItemEqual(itemstack)) continue;
            return true;
        }
        return false;
    }
}

