/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.reservoir.TileReservoir;
import crazypants.enderio.tool.ToolUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockReservoir
extends BlockEio
implements IResourceTooltipProvider {
    private IIcon[] mbIcons = new IIcon[8];
    IIcon switchIcon;

    public static BlockReservoir create() {
        BlockReservoir result = new BlockReservoir();
        result.init();
        return result;
    }

    private BlockReservoir() {
        super(ModObject.blockReservoir.unlocalisedName, TileReservoir.class, Material.rock);
        this.setStepSound(Block.soundTypeStone);
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        TileEntity te;
        if (!entityPlayer.isSneaking() && entityPlayer.inventory.getCurrentItem() != null && (te = world.getTileEntity(x, y, z)) instanceof TileReservoir) {
            TileReservoir tank = ((TileReservoir)te).getController();
            if (ToolUtil.isToolEquipped(entityPlayer) && tank.isMultiblock()) {
                tank.setAutoEject(!tank.isAutoEject());
                for (BlockCoord bc : tank.multiblock) {
                    world.markBlockForUpdate(bc.x, bc.y, bc.z);
                }
                return true;
            }
            if (FluidUtil.fillInternalTankFromPlayerHandItem((World)world, (int)x, (int)y, (int)z, (EntityPlayer)entityPlayer, (ITankAccess)tank)) {
                return true;
            }
            if (FluidUtil.fillPlayerHandItemFromInternalTank((World)world, (int)x, (int)y, (int)z, (EntityPlayer)entityPlayer, (ITankAccess)tank)) {
                return true;
            }
        }
        return super.onBlockActivated(world, x, y, z, entityPlayer, par6, par7, par8, par9);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof TileReservoir)) {
            return super.getSelectedBoundingBoxFromPool(world, x, y, z);
        }
        TileReservoir tr = (TileReservoir)te;
        if (!tr.isMultiblock()) {
            return super.getSelectedBoundingBoxFromPool(world, x, y, z);
        }
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (BlockCoord bc : tr.multiblock) {
            min.x = Math.min(min.x, (double)bc.x);
            max.x = Math.max(max.x, (double)(bc.x + 1));
            min.y = Math.min(min.y, (double)bc.y);
            max.y = Math.max(max.y, (double)(bc.y + 1));
            min.z = Math.min(min.z, (double)bc.z);
            max.z = Math.max(max.z, (double)(bc.z + 1));
        }
        return AxisAlignedBB.getBoundingBox((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileReservoir();
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        if (world.isRemote) {
            return;
        }
        TileReservoir tr = (TileReservoir)world.getTileEntity(x, y, z);
        boolean res = tr.onBlockAdded();
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        if (world.isRemote) {
            return;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileReservoir) {
            ((TileReservoir)te).onNeighborBlockChange(block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister IIconRegister2) {
        this.blockIcon = IIconRegister2.registerIcon("enderio:reservoir");
        for (MbFace face : MbFace.values()) {
            this.mbIcons[face.ordinal()] = IIconRegister2.registerIcon("enderio:" + face.iconName);
        }
        this.switchIcon = IIconRegister2.registerIcon("enderio:reservoirSwitch");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int blockSide) {
        if (y < 0 || y >= 256) {
            return false;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof TileReservoir)) {
            return true;
        }
        TileReservoir tr = (TileReservoir)te;
        return !tr.isMultiblock();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!(te instanceof TileReservoir)) {
            return this.blockIcon;
        }
        TileReservoir tr = (TileReservoir)te;
        if (!tr.isMultiblock()) {
            return this.blockIcon;
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)blockSide);
        TileReservoir.Pos pos = tr.pos;
        if (tr.front == side || tr.front == side.getOpposite()) {
            boolean isRight = tr.isVertical() ? !pos.isRight(side) : pos.isRight(side);
            if (pos.isTop) {
                return isRight ? this.mbIcons[MbFace.TR.ordinal()] : this.mbIcons[MbFace.TL.ordinal()];
            }
            return isRight ? this.mbIcons[MbFace.BR.ordinal()] : this.mbIcons[MbFace.BL.ordinal()];
        }
        if (tr.up == side || tr.up == side.getOpposite()) {
            if (tr.isVertical()) {
                if (tr.right.offsetX != 0) {
                    return pos.isRight ? this.mbIcons[MbFace.L.ordinal()] : this.mbIcons[MbFace.R.ordinal()];
                }
                return pos.isRight ? this.mbIcons[MbFace.T.ordinal()] : this.mbIcons[MbFace.B.ordinal()];
            }
            if (tr.up == side) {
                return pos.isRight ? this.mbIcons[MbFace.L.ordinal()] : this.mbIcons[MbFace.R.ordinal()];
            }
            return pos.isRight ? this.mbIcons[MbFace.R.ordinal()] : this.mbIcons[MbFace.L.ordinal()];
        }
        if (tr.isVertical()) {
            return pos.isTop ? this.mbIcons[MbFace.T.ordinal()] : this.mbIcons[MbFace.B.ordinal()];
        }
        return pos.isTop(side) ? this.mbIcons[MbFace.L.ordinal()] : this.mbIcons[MbFace.R.ordinal()];
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.getUnlocalizedName();
    }

    private static enum MbFace {
        TL("reservoirMbTl"),
        TR("reservoirMbTr"),
        BL("reservoirMbBl"),
        BR("reservoirMbBr"),
        T("reservoirMbT"),
        B("reservoirMbB"),
        L("reservoirMbL"),
        R("reservoirMbR");

        String iconName;

        private MbFace(String iconName) {
            this.iconName = iconName;
        }
    }
}

