/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.machine.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public abstract class AbstractMachineRecipe
implements IMachineRecipe {
    @Override
    public int getEnergyRequired(MachineRecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return 0;
        }
        IRecipe recipe = this.getRecipeForInputs(inputs);
        return recipe == null ? 0 : recipe.getEnergyRequired();
    }

    @Override
    public RecipeBonusType getBonusType(MachineRecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return RecipeBonusType.NONE;
        }
        IRecipe recipe = this.getRecipeForInputs(inputs);
        return recipe == null ? RecipeBonusType.NONE : recipe.getBonusType();
    }

    public abstract IRecipe getRecipeForInputs(MachineRecipeInput[] var1);

    @Override
    public List<MachineRecipeInput> getQuantitiesConsumed(MachineRecipeInput[] inputs) {
        IRecipe recipe = this.getRecipeForInputs(inputs);
        ArrayList<MachineRecipeInput> result = new ArrayList<MachineRecipeInput>();
        MachineRecipeInput[] availableInputs = new MachineRecipeInput[inputs.length];
        int i = 0;
        for (MachineRecipeInput available : inputs) {
            availableInputs[i] = available.copy();
            ++i;
        }
        RecipeInput[] requiredIngredients = new RecipeInput[recipe.getInputs().length];
        i = 0;
        for (RecipeInput ri : recipe.getInputs()) {
            requiredIngredients[i] = ri.copy();
            ++i;
        }
        for (RecipeInput required : requiredIngredients) {
            MachineRecipeInput available;
            MachineRecipeInput[] machineRecipeInputArray = availableInputs;
            int n = machineRecipeInputArray.length;
            for (int j = 0; !(j >= n || this.isValid(available = machineRecipeInputArray[j]) && this.consume(required, available, result)); ++j) {
            }
        }
        return result;
    }

    protected boolean consume(RecipeInput required, MachineRecipeInput available, List<MachineRecipeInput> consumedInputs) {
        if (required.isInput(available.fluid)) {
            consumedInputs.add(new MachineRecipeInput(available.slotNumber, required.getFluidInput().copy()));
            return true;
        }
        if (required.isInput(available.item) && (required.getSlotNumber() == -1 || required.getSlotNumber() == available.slotNumber)) {
            ItemStack availableStack = available.item;
            ItemStack requiredStack = required.getInput();
            ItemStack consumedStack = requiredStack.copy();
            consumedStack.stackSize = Math.min(requiredStack.stackSize, availableStack.stackSize);
            requiredStack.stackSize -= consumedStack.stackSize;
            availableStack.stackSize -= consumedStack.stackSize;
            consumedInputs.add(new MachineRecipeInput(available.slotNumber, consumedStack));
            if (requiredStack.stackSize <= 0) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValid(MachineRecipeInput input) {
        if (input == null) {
            return false;
        }
        if (input.item != null && input.item.stackSize > 0) {
            return true;
        }
        return input.fluid != null && input.fluid.amount > 0;
    }

    @Override
    public float getExperienceForOutput(ItemStack output) {
        return 0.0f;
    }

    @Override
    public boolean isRecipe(MachineRecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return false;
        }
        IRecipe recipe = this.getRecipeForInputs(inputs);
        return recipe != null;
    }

    @Override
    public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return new IMachineRecipe.ResultStack[0];
        }
        IRecipe recipe = this.getRecipeForInputs(inputs);
        if (recipe == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        RecipeOutput[] outputs = recipe.getOutputs();
        if (outputs == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        ArrayList<IMachineRecipe.ResultStack> result = new ArrayList<IMachineRecipe.ResultStack>();
        for (RecipeOutput output : outputs) {
            if (!(output.getChance() >= chance)) continue;
            if (output.isFluid()) {
                result.add(new IMachineRecipe.ResultStack(output.getFluidOutput().copy()));
                continue;
            }
            result.add(new IMachineRecipe.ResultStack(output.getOutput().copy()));
        }
        return result.toArray(new IMachineRecipe.ResultStack[result.size()]);
    }
}

