/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.ranged;

import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.machine.ranged.IRanged;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class RangeEntity
extends Entity {
    int totalLife;
    int lifeSpan;
    float range;
    private IRanged spawnGuard;

    public RangeEntity(IRanged sg) {
        super(sg.getWorld());
        this.lifeSpan = this.totalLife = 20;
        this.spawnGuard = sg;
        BlockCoord bc = this.spawnGuard.getLocation();
        this.setPosition((double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5);
        this.ignoreFrustumCheck = true;
        this.range = sg.getRange() + 0.5f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRender3d(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }

    protected void entityInit() {
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    public void onUpdate() {
        super.onUpdate();
        --this.lifeSpan;
        BlockCoord bc = this.spawnGuard.getLocation();
        if (!(this.worldObj.getTileEntity(bc.x, bc.y, bc.z) instanceof IRanged)) {
            this.setDead();
        }
        if (!this.spawnGuard.isShowingRange()) {
            this.setDead();
        }
    }

    protected void readEntityFromNBT(NBTTagCompound p_70037_1_) {
    }

    protected void writeEntityToNBT(NBTTagCompound p_70014_1_) {
    }
}

