/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.power.TileCapacitorBank;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketClientState
implements IMessage,
IMessageHandler<PacketClientState, IMessage> {
    private int x;
    private int y;
    private int z;
    private RedstoneControlMode inputMode;
    private RedstoneControlMode outputMode;
    private int maxInput;
    private int maxOutput;

    public PacketClientState() {
    }

    public PacketClientState(TileCapacitorBank capBank) {
        this.x = capBank.xCoord;
        this.y = capBank.yCoord;
        this.z = capBank.zCoord;
        this.inputMode = capBank.getInputControlMode();
        this.outputMode = capBank.getOutputControlMode();
        this.maxInput = capBank.getMaxInput();
        this.maxOutput = capBank.getMaxOutput();
    }

    public void toBytes(ByteBuf dos) {
        dos.writeInt(this.x);
        dos.writeInt(this.y);
        dos.writeInt(this.z);
        dos.writeShort((int)((short)this.inputMode.ordinal()));
        dos.writeShort((int)((short)this.outputMode.ordinal()));
        dos.writeInt(this.maxInput);
        dos.writeInt(this.maxOutput);
    }

    public void fromBytes(ByteBuf data) {
        this.x = data.readInt();
        this.y = data.readInt();
        this.z = data.readInt();
        short inputOrdinal = data.readShort();
        short outputOrdinal = data.readShort();
        this.outputMode = RedstoneControlMode.values()[outputOrdinal];
        this.inputMode = RedstoneControlMode.values()[inputOrdinal];
        this.maxInput = data.readInt();
        this.maxOutput = data.readInt();
    }

    public IMessage onMessage(PacketClientState message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().playerEntity;
        TileEntity te = player.worldObj.getTileEntity(message.x, message.y, message.z);
        if (te instanceof TileCapacitorBank) {
            TileCapacitorBank cb = (TileCapacitorBank)te;
            cb.setInputControlMode(message.inputMode);
            cb.setOutputControlMode(message.outputMode);
            cb.setMaxInput(message.maxInput);
            cb.setMaxOutput(message.maxOutput);
        }
        return null;
    }
}

