/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.gui.GuiOverlayIoConfig;
import crazypants.enderio.machine.power.ContainerCapacitorBank;
import crazypants.enderio.machine.power.PacketClientState;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.power.TileCapacitorBank;
import crazypants.enderio.network.PacketHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import org.lwjgl.opengl.GL11;

public class GuiCapacitorBank
extends GuiContainerBase {
    protected static final int INPUT_BUTTON_ID = 18;
    protected static final int OUTPUT_BUTTON_ID = 37;
    protected static final int CONFIG_ID = 377996104;
    private static final int POWER_X = 29;
    private static final int POWER_Y = 9;
    private static final int POWER_WIDTH = 10;
    private static final int POWER_HEIGHT = 68;
    protected static final int BOTTOM_POWER_Y = 77;
    private int inputX = 102;
    private int inputY = 18;
    private int outputX = 102;
    private int outputY = 36;
    private int rightMargin = 32;
    private final TileCapacitorBank capBank;
    private RedstoneModeButton inputRsButton;
    private RedstoneModeButton outputRsButton;
    private GuiTextField maxInputTF;
    private GuiTextField maxOutputTF;
    private GuiOverlayIoConfig configOverlay;
    private IconButton configB;

    public GuiCapacitorBank(Entity player, InventoryPlayer playerInv, TileCapacitorBank te) {
        super((Container)new ContainerCapacitorBank(player, playerInv, te));
        BlockCoord[] mb;
        this.capBank = te;
        this.xSize = 218;
        this.addToolTip(new GuiToolTip(new Rectangle(5, 9, 10, 68), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(PowerDisplayUtil.formatPower(GuiCapacitorBank.this.capBank.getEnergyStored()) + " " + PowerDisplayUtil.ofStr());
                this.text.add(PowerDisplayUtil.formatPower(GuiCapacitorBank.this.capBank.getMaxEnergyStored()) + " " + PowerDisplayUtil.abrevation());
            }
        });
        int x = this.xSize - this.rightMargin - 16 - 21;
        int y = this.inputY;
        this.inputRsButton = new RedstoneModeButton((IGuiScreen)this, -1, x, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                GuiCapacitorBank.this.capBank.setInputControlMode(mode);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketClientState(GuiCapacitorBank.this.capBank));
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return GuiCapacitorBank.this.capBank.getInputControlMode();
            }
        });
        this.inputRsButton.setTooltipKey("enderio.gui.capBank.inputRs");
        this.outputRsButton = new RedstoneModeButton((IGuiScreen)this, -1, x, y += 18, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                GuiCapacitorBank.this.capBank.setOutputControlMode(mode);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketClientState(GuiCapacitorBank.this.capBank));
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return GuiCapacitorBank.this.capBank.getOutputControlMode();
            }
        });
        this.outputRsButton.setTooltipKey("enderio.gui.capBank.outputRs");
        this.configB = new IconButton((IGuiScreen)this, 377996104, x, y += 20, (IWidgetIcon)IconEIO.IO_CONFIG_UP);
        this.configB.setToolTip(new String[]{EnderIO.lang.localize("gui.machine.ioMode.overlay.tooltip")});
        ArrayList<BlockCoord> coords = new ArrayList<BlockCoord>();
        if (te.isMultiblock() && (mb = te.getController().multiblock) != null) {
            coords.addAll(Arrays.asList(mb));
        }
        if (coords.isEmpty()) {
            coords.add(te.getLocation());
        }
        this.configOverlay = new GuiOverlayIoConfig(coords){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                GuiCapacitorBank.this.configB.setIcon((IWidgetIcon)(visible ? IconEIO.IO_CONFIG_DOWN : IconEIO.IO_CONFIG_UP));
            }

            @Override
            protected String getLabelForMode(IoMode mode) {
                if (mode == IoMode.PUSH) {
                    return EnderIO.lang.localize("gui.capBank.outputMode");
                }
                if (mode == IoMode.PULL) {
                    return EnderIO.lang.localize("gui.capBank.inputMode");
                }
                return super.getLabelForMode(mode);
            }
        };
        this.addOverlay(this.configOverlay);
    }

    protected void actionPerformed(GuiButton b) {
        super.actionPerformed(b);
        if (b.id == 377996104) {
            boolean vis = !this.configOverlay.isVisible();
            this.configOverlay.setVisible(vis);
        }
    }

    public void initGui() {
        super.initGui();
        this.configB.onGuiInit();
        int x = this.guiLeft + this.xSize - this.rightMargin - 16;
        int y = this.guiTop + this.inputY;
        FontRenderer fontRenderer = this.getFontRenderer();
        this.inputRsButton.onGuiInit();
        this.outputRsButton.onGuiInit();
        x = this.guiLeft + this.inputX;
        y = this.guiTop + this.inputY;
        this.maxInputTF = new GuiTextField(fontRenderer, x, y, 68, 16);
        this.maxInputTF.setCanLoseFocus(true);
        this.maxInputTF.setMaxStringLength(10);
        this.maxInputTF.setFocused(false);
        this.maxInputTF.setText(PowerDisplayUtil.formatPower(this.capBank.getMaxInput()));
        x = this.guiLeft + this.outputX;
        y = this.guiTop + this.outputY;
        this.maxOutputTF = new GuiTextField(fontRenderer, x, y, 68, 16);
        this.maxOutputTF.setCanLoseFocus(true);
        this.maxOutputTF.setMaxStringLength(10);
        this.maxOutputTF.setFocused(true);
        this.maxOutputTF.setText(PowerDisplayUtil.formatPower(this.capBank.getMaxOutput()));
    }

    protected void keyTyped(char par1, int par2) {
        super.keyTyped(par1, par2);
        if (par1 == 'e') {
            super.keyTyped(par1, 1);
        }
        this.maxInputTF.textboxKeyTyped(par1, par2);
        this.maxOutputTF.textboxKeyTyped(par1, par2);
        this.updateInputOutput();
    }

    private void updateInputOutput() {
        int output;
        int input = this.parsePower(this.maxInputTF);
        if (input >= 0 && this.capBank.getMaxInput() != input) {
            this.setMaxInput(input);
        }
        if ((output = this.parsePower(this.maxOutputTF)) >= 0 && this.capBank.getMaxOutput() != output) {
            this.setMaxOutput(output);
        }
    }

    private void setMaxOutput(int output) {
        if (output != this.capBank.getMaxOutput()) {
            this.capBank.setMaxOutput(output);
            this.maxOutputTF.setText(PowerDisplayUtil.formatPower(this.capBank.getMaxOutput()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketClientState(this.capBank));
        }
    }

    private void setMaxInput(int input) {
        if (input != this.capBank.getMaxInput()) {
            this.capBank.setMaxInput(input);
            this.maxInputTF.setText(PowerDisplayUtil.formatPower(this.capBank.getMaxInput()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketClientState(this.capBank));
        }
    }

    private int parsePower(GuiTextField tf) {
        String txt = tf.getText();
        try {
            Integer power = PowerDisplayUtil.parsePower(txt);
            if (power == null) {
                return -1;
            }
            return power;
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected void mouseClicked(int par1, int par2, int par3) {
        super.mouseClicked(par1, par2, par3);
        this.maxInputTF.mouseClicked(par1, par2, par3);
        this.maxOutputTF.mouseClicked(par1, par2, par3);
    }

    public void updateScreen() {
        this.maxInputTF.updateCursorCounter();
        this.maxOutputTF.updateCursorCounter();
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)"enderio:textures/gui/capacitorBank.png");
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize - 21, this.ySize);
        int i1 = this.capBank.getEnergyStoredScaled(68);
        this.drawTexturedModalRect(sx + 29, sy + 77 - i1, 197, 0, 10, i1);
        for (int i = 0; i < this.buttonList.size(); ++i) {
            GuiButton guibutton = (GuiButton)this.buttonList.get(i);
            guibutton.drawButton(this.mc, 0, 0);
        }
        this.maxInputTF.drawTextBox();
        this.maxOutputTF.drawTextBox();
        int midX = sx + this.xSize / 2;
        String str = EnderIO.lang.localize("gui.capBank.maxIo") + " " + PowerDisplayUtil.formatPower(this.capBank.getMaxIO()) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
        FontRenderer fontRenderer = this.getFontRenderer();
        int swid = fontRenderer.getStringWidth(str);
        int x = midX - swid / 2;
        int y = this.guiTop + 5;
        this.drawString(fontRenderer, str, x, y, -1);
        str = EnderIO.lang.localize("gui.capBank.maxInput") + ":";
        swid = fontRenderer.getStringWidth(str);
        x = this.guiLeft + this.inputX - swid - 3;
        y = this.guiTop + this.inputY + 2;
        this.drawString(fontRenderer, str, x, y, -1);
        str = EnderIO.lang.localize("gui.capBank.maxOutput") + ":";
        swid = fontRenderer.getStringWidth(str);
        x = this.guiLeft + this.outputX - swid - 3;
        y = this.guiTop + this.outputY + 2;
        this.drawString(fontRenderer, str, x, y, -1);
    }

    public void drawHoveringText(List par1List, int par2, int par3, FontRenderer font) {
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        super.drawHoveringText(par1List, par2 + 24, par3, font);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
    }

    public int getGuiLeft() {
        return this.guiLeft + 24;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getXSize() {
        return this.xSize - 42;
    }

    public int getOverlayOffsetX() {
        return 21;
    }

    public FontRenderer getFontRenderer() {
        return Minecraft.getMinecraft().fontRenderer;
    }
}

