/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.PaintSourceValidator;
import crazypants.enderio.machine.painter.PainterUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;

public class TileEntityPainter
extends AbstractPoweredTaskEntity
implements ISidedInventory {
    public TileEntityPainter() {
        super(new SlotDefinition(2, 1));
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemstack, int j) {
        return super.canExtractItem(i, itemstack, j) && PainterUtil.isMetadataEquivelent(itemstack, this.inventory[2]);
    }

    @Override
    public String getInventoryName() {
        return "Auto Painter";
    }

    @Override
    public boolean hasCustomInventoryName() {
        return false;
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, ItemStack itemStack) {
        if (i > 1) {
            return false;
        }
        if (i == 0) {
            List<IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForInput(this.getMachineName(), MachineRecipeInput.create(i, itemStack));
            if (this.inventory[1] == null) {
                return !recipes.isEmpty();
            }
            for (IMachineRecipe rec : recipes) {
                BasicPainterTemplate temp;
                if (!(rec instanceof BasicPainterTemplate) || !(temp = (BasicPainterTemplate)rec).isValidPaintSource(this.inventory[1])) continue;
                return true;
            }
            return false;
        }
        if (this.inventory[0] == null) {
            Map<String, IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForMachine(this.getMachineName());
            for (IMachineRecipe rec : recipes.values()) {
                BasicPainterTemplate temp;
                if (!(rec instanceof BasicPainterTemplate) || !(temp = (BasicPainterTemplate)rec).isValidPaintSource(itemStack)) continue;
                return true;
            }
            return PaintSourceValidator.instance.isValidSourceDefault(itemStack);
        }
        return MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineName(), i == 0 ? MachineRecipeInput.create(0, itemStack) : this.targetInput(), i == 1 ? MachineRecipeInput.create(1, itemStack) : this.paintSource()) != null;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockPainter.unlocalisedName;
    }

    private MachineRecipeInput targetInput() {
        return MachineRecipeInput.create(0, this.inventory[0]);
    }

    private MachineRecipeInput paintSource() {
        return MachineRecipeInput.create(1, this.inventory[1]);
    }

    @Override
    protected int getNumCanMerge(ItemStack itemStack, ItemStack result) {
        int invId;
        int cookedId;
        if (result == null || !result.isItemEqual(this.inventory[2])) {
            return 0;
        }
        if (result.hasTagCompound() && this.inventory[2].hasTagCompound() && (cookedId = result.getTagCompound().getInteger("sourceBlockId")) != (invId = this.inventory[2].getTagCompound().getInteger("sourceBlockId"))) {
            return 0;
        }
        return Math.min(itemStack.getMaxStackSize() - itemStack.stackSize, result.stackSize);
    }
}

