/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.painter.IPaintableTileEntity;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileEntityPaintedBlock
extends TileEntityEio
implements IPaintableTileEntity {
    private static final String KEY_SOURCE_BLOCK_ID = "sourceBlock";
    private static final String KEY_SOURCE_BLOCK_META = "sourceBlockMeta";
    private Block sourceBlock = null;
    private int sourceBlockMetadata;

    public void readCustomNBT(NBTTagCompound nbtRoot) {
        String sourceBlockStr = nbtRoot.getString(KEY_SOURCE_BLOCK_ID);
        this.sourceBlock = Block.getBlockFromName((String)sourceBlockStr);
        this.sourceBlockMetadata = nbtRoot.getInteger(KEY_SOURCE_BLOCK_META);
    }

    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        if (this.sourceBlock != null) {
            nbtRoot.setString(KEY_SOURCE_BLOCK_ID, Block.blockRegistry.getNameForObject((Object)this.sourceBlock));
        }
        nbtRoot.setInteger(KEY_SOURCE_BLOCK_META, this.sourceBlockMetadata);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.updateBlock();
    }

    @Override
    public Block getSourceBlock() {
        return this.sourceBlock;
    }

    @Override
    public void setSourceBlock(Block sourceBlock) {
        this.sourceBlock = sourceBlock;
    }

    @Override
    public int getSourceBlockMetadata() {
        return this.sourceBlockMetadata;
    }

    @Override
    public void setSourceBlockMetadata(int sourceBlockMetadata) {
        this.sourceBlockMetadata = sourceBlockMetadata;
    }

    public boolean shouldUpdate() {
        return false;
    }
}

