/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.BlockItemPaintedStair;
import crazypants.enderio.machine.painter.IPaintedBlock;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.machine.painter.TileEntityPaintedBlock;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPaintedStair
extends BlockStairs
implements ITileEntityProvider,
IPaintedBlock {
    private IIcon lastRemovedComponetIcon = null;
    private Random rand = new Random();

    public static BlockPaintedStair create() {
        BlockPaintedStair result = new BlockPaintedStair();
        result.init();
        return result;
    }

    protected BlockPaintedStair() {
        super(Blocks.stone, 0);
        this.setCreativeTab(null);
        this.setBlockName(ModObject.blockPaintedStair.unlocalisedName);
        this.setLightOpacity(0);
    }

    private void init() {
        GameRegistry.registerBlock((Block)this, BlockItemPaintedStair.class, (String)ModObject.blockPaintedStair.unlocalisedName);
        GameRegistry.registerTileEntity(TileEntityPaintedBlock.class, (String)(ModObject.blockPaintedStair.unlocalisedName + "TileEntity"));
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, new PainterTemplate());
    }

    public static ItemStack createItemStackForSourceBlock(Block block, int damage) {
        ItemStack result = new ItemStack((Block)EnderIO.blockPaintedStair, 1, damage);
        PainterUtil.setSourceBlock(result, block, damage);
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(PainterUtil.applyDefaultPaintedState(new ItemStack(item)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        IIcon tex = null;
        TileEntityPaintedBlock cb = (TileEntityPaintedBlock)world.getTileEntity(target.blockX, target.blockY, target.blockZ);
        Block b = cb.getSourceBlock();
        if (b != null) {
            tex = b.getIcon(ForgeDirection.NORTH.ordinal(), cb.getSourceBlockMetadata());
        }
        if (tex == null) {
            tex = this.blockIcon;
        }
        this.lastRemovedComponetIcon = tex;
        this.addBlockHitEffects(world, effectRenderer, target.blockX, target.blockY, target.blockZ, target.sideHit, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        IIcon tex = this.lastRemovedComponetIcon;
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    int i2 = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, i2, 0).applyColourMultiplier(x, y, z);
                    fx.setParticleIcon(tex);
                    effectRenderer.addEffect((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, EffectRenderer effectRenderer, int x, int y, int z, int side, IIcon tex) {
        float f = 0.1f;
        double d0 = (double)x + this.rand.nextDouble() * (this.getBlockBoundsMaxX() - this.getBlockBoundsMinX() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinX();
        double d1 = (double)y + this.rand.nextDouble() * (this.getBlockBoundsMaxY() - this.getBlockBoundsMinY() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinY();
        double d2 = (double)z + this.rand.nextDouble() * (this.getBlockBoundsMaxZ() - this.getBlockBoundsMinZ() - (double)(f * 2.0f)) + (double)f + this.getBlockBoundsMinZ();
        if (side == 0) {
            d1 = (double)y + this.getBlockBoundsMinY() - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.getBlockBoundsMaxY() + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.getBlockBoundsMinZ() - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.getBlockBoundsMaxZ() + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.getBlockBoundsMinX() - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.getBlockBoundsMaxX() + (double)f;
        }
        EntityDiggingFX digFX = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, side, 0);
        digFX.applyColourMultiplier(x, y, z).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f);
        digFX.setParticleIcon(tex);
        effectRenderer.addEffect((EntityFX)digFX);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.getBlockMetadata(x, y, z);
        boolean flipped = (meta & 4) != 0;
        return (meta & 3) + side.ordinal() == 5 || side == ForgeDirection.UP && flipped;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return tef.getSourceBlock().getIcon(blockSide, tef.getSourceBlockMetadata());
        }
        return Blocks.anvil.getIcon(world, x, y, z, blockSide);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister IIconRegister2) {
        this.blockIcon = IIconRegister2.registerIcon("enderio:conduitConnector");
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileEntityPaintedBlock();
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        TileEntityPaintedBlock tef;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock && (tef = (TileEntityPaintedBlock)te).getSourceBlock() != null) {
            return Math.min(super.getLightOpacity(world, x, y, z), tef.getSourceBlock().getLightOpacity());
        }
        return super.getLightOpacity(world, x, y, z);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        Block b = PainterUtil.getSourceBlock(stack);
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityPaintedBlock) {
            TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
            tef.setSourceBlock(b);
            tef.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(stack));
        }
        world.markBlockForUpdate(x, y, z);
        super.onBlockPlacedBy(world, x, y, z, player, stack);
    }

    public void breakBlock(World world, int x, int y, int z, Block par5, int par6) {
        if (!world.isRemote && world.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            TileEntity te = world.getTileEntity(x, y, z);
            if (te instanceof TileEntityPaintedBlock) {
                TileEntityPaintedBlock tef = (TileEntityPaintedBlock)te;
                ItemStack itemStack = BlockPaintedStair.createItemStackForSourceBlock(tef.getSourceBlock(), tef.getSourceBlockMetadata());
                float f = 0.7f;
                double d0 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
                entityitem.delayBeforeCanPickup = 10;
                world.spawnEntityInWorld((Entity)entityitem);
            } else {
                System.out.println("dropBlockAsItem_do: No tile entity.");
            }
        }
        world.removeTileEntity(x, y, z);
    }

    public int quantityDropped(Random par1Random) {
        return 0;
    }

    public final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate() {
            super(new Block[0]);
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            if (paintSource == null) {
                return new IMachineRecipe.ResultStack[0];
            }
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockPaintedStair.createItemStackForSourceBlock(Block.getBlockFromItem((Item)paintSource.getItem()), paintSource.getItemDamage()))};
        }

        @Override
        public boolean isValidTarget(ItemStack target) {
            if (target == null) {
                return false;
            }
            Block blk = Block.getBlockFromItem((Item)target.getItem());
            return blk instanceof BlockStairs;
        }
    }
}

