/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.weather;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.obelisk.weather.ContainerWeatherObelisk;
import crazypants.enderio.machine.obelisk.weather.PacketActivateWeather;
import crazypants.enderio.machine.obelisk.weather.TileWeatherObelisk;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiWeatherObelisk
extends GuiPoweredMachineBase<TileWeatherObelisk> {
    private static final ResourceLocation texture = new ResourceLocation("enderio:textures/gui/weatherObelisk.png");
    private static final NumberFormat fmt = NumberFormat.getNumberInstance();

    public GuiWeatherObelisk(InventoryPlayer inventory, TileWeatherObelisk tileEntity) {
        super(tileEntity, (Container)new ContainerWeatherObelisk(inventory, tileEntity));
        this.addProgressTooltip(79, 29, 18, 31);
    }

    @Override
    public void initGui() {
        super.initGui();
        int x = this.xSize / 2 - 8;
        int y = 8;
        this.addButton(new IconButton((IGuiScreen)this, 0, x - 30, y, (IWidgetIcon)IconEIO.SUN), TileWeatherObelisk.WeatherTask.CLEAR);
        this.addButton(new IconButton((IGuiScreen)this, 1, x, y, (IWidgetIcon)IconEIO.RAIN), TileWeatherObelisk.WeatherTask.RAIN);
        this.addButton(new IconButton((IGuiScreen)this, 2, x + 30, y, (IWidgetIcon)IconEIO.THUNDER), TileWeatherObelisk.WeatherTask.STORM);
        this.refreshButtons();
    }

    private void addButton(IconButton button, TileWeatherObelisk.WeatherTask task) {
        String tt1 = EnumChatFormatting.WHITE + EnderIO.lang.localize("gui.weather.task." + task.name().toLowerCase(Locale.US));
        String tt2 = EnumChatFormatting.AQUA + String.format(EnderIO.lang.localize("gui.weather.requireditem"), EnumChatFormatting.WHITE + task.requiredItem().getDisplayName());
        String tt3 = String.format("%s%s %s%s", EnumChatFormatting.GREEN, fmt.format(task.power), EnumChatFormatting.WHITE, EnderIO.lang.localize("power.rf"));
        button.setToolTip(new String[]{tt1, tt2, tt3});
        button.onGuiInit();
    }

    public void updateScreen() {
        super.updateScreen();
        if (((TileWeatherObelisk)this.getTileEntity()).getWorldObj().getTotalWorldTime() % 20L == 0L) {
            this.refreshButtons();
        }
    }

    private void refreshButtons() {
        for (GuiButton button : this.buttonList) {
            TileWeatherObelisk.WeatherTask[] tasks = TileWeatherObelisk.WeatherTask.values();
            if (button.id < 0 || button.id >= tasks.length) continue;
            TileWeatherObelisk.WeatherTask task = TileWeatherObelisk.WeatherTask.values()[button.id];
            if (TileWeatherObelisk.WeatherTask.worldIsState(task, ((TileWeatherObelisk)this.getTileEntity()).getWorldObj().getWorldInfo())) {
                button.enabled = false;
                continue;
            }
            button.enabled = true;
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        this.mc.renderEngine.bindTexture(texture);
        this.drawTexturedModalRect(this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        if (this.shouldRenderProgress() && ((TileWeatherObelisk)this.getTileEntity()).activeTask != null) {
            int barHeight = this.getProgressScaled(31);
            Color color = ((TileWeatherObelisk)this.getTileEntity()).activeTask.color;
            GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            this.drawTexturedModalRect(this.getGuiLeft() + 81, this.getGuiTop() + 58 - barHeight, this.getXSize(), 32 - barHeight, 12, barHeight);
        }
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
    }

    @Override
    protected int getPowerHeight() {
        return super.getPowerHeight() + 20;
    }

    @Override
    protected int getPowerU() {
        return super.getPowerU();
    }

    @Override
    protected int getPowerV() {
        return 34;
    }

    @Override
    protected int getPowerX() {
        return super.getPowerX();
    }

    @Override
    protected int getPowerY() {
        return super.getPowerY();
    }

    protected void actionPerformed(GuiButton b) {
        super.actionPerformed(b);
        if (b.id >= 0 && b.id <= 2) {
            ((TileWeatherObelisk)this.getTileEntity()).startTask(b.id);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketActivateWeather((TileWeatherObelisk)this.getTileEntity(), TileWeatherObelisk.WeatherTask.values()[b.id]));
        }
    }
}

