/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.inhibitor;

import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.obelisk.BlockObeliskAbstract;
import crazypants.enderio.machine.obelisk.inhibitor.ContainerInhibitorObelisk;
import crazypants.enderio.machine.obelisk.inhibitor.GuiInhibitorObelisk;
import crazypants.enderio.machine.obelisk.inhibitor.TileInhibitorObelisk;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BlockInhibitorObelisk
extends BlockObeliskAbstract<TileInhibitorObelisk> {
    public static BlockInhibitorObelisk instance;
    public Map<BlockCoord, Float> activeInhibitors = Maps.newHashMap();

    public static BlockInhibitorObelisk create() {
        BlockInhibitorObelisk res = new BlockInhibitorObelisk();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        instance = res;
        return instance;
    }

    protected BlockInhibitorObelisk() {
        super(ModObject.blockInhibitorObelisk, TileInhibitorObelisk.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return ID == this.getGuiId() ? new ContainerInhibitorObelisk(player.inventory, (AbstractMachineEntity)world.getTileEntity(x, y, z)) : null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileInhibitorObelisk te;
        if (ID == this.getGuiId() && (te = (TileInhibitorObelisk)world.getTileEntity(x, y, z)) != null) {
            return new GuiInhibitorObelisk(te, (Container)new ContainerInhibitorObelisk(player.inventory, te));
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 104;
    }

    @SubscribeEvent
    public void onTeleport(TeleportEntityEvent event) {
        for (Map.Entry<BlockCoord, Float> e : this.activeInhibitors.entrySet()) {
            TileEntity te;
            BlockCoord bc = e.getKey();
            int dist = bc.getDist(new BlockCoord(event.targetX, event.targetY, event.targetZ));
            if (!((float)dist < e.getValue().floatValue()) || !((te = bc.getTileEntity((IBlockAccess)event.entity.worldObj)) instanceof TileInhibitorObelisk) || !((TileInhibitorObelisk)te).isActive()) continue;
            event.setCanceled(true);
        }
    }
}

