/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.button.CheckBox;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.ContainerNoInv;
import crazypants.enderio.machine.monitor.PacketPowerMonitor;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.NumberFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiPowerMonitor
extends GuiContainerBase {
    private static final NumberFormat INT_NF = NumberFormat.getIntegerInstance();
    private static final int ICON_SIZE = 16;
    private static final int SPACING = 6;
    private static final int MARGIN = 7;
    private static final int WIDTH = 210;
    private static final int HEIGHT = 146;
    private static final int POWER_X = 185;
    private static final int POWER_Y = 9;
    private static final int POWER_WIDTH = 10;
    private static final int POWER_HEIGHT = 130;
    protected static final int BOTTOM_POWER_Y = 139;
    private final TilePowerMonitor te;
    private boolean isRedstoneMode = false;
    private CheckBox enabledB;
    private TextFieldEnder startTF;
    private TextFieldEnder endTF;
    private String titleStr;
    private String engineTxt1;
    private String engineTxt2;
    private String engineTxt3;
    private String engineTxt4;
    private String engineTxt5;
    private String engineTxt6;
    private String monHeading1;
    private String monHeading2;
    private String monHeading3;
    private String monHeading4;
    private String monHeading5;

    public GuiPowerMonitor(InventoryPlayer playerInv, final TilePowerMonitor te) {
        super((Container)new ContainerNoInv((IInventory)te));
        this.te = te;
        this.xSize = 210;
        this.ySize = 146;
        this.titleStr = EnderIO.lang.localize("gui.powerMonitor.engineControl");
        this.engineTxt1 = EnderIO.lang.localize("gui.powerMonitor.engineSection1");
        this.engineTxt2 = EnderIO.lang.localize("gui.powerMonitor.engineSection2");
        this.engineTxt3 = EnderIO.lang.localize("gui.powerMonitor.engineSection3");
        this.engineTxt4 = EnderIO.lang.localize("gui.powerMonitor.engineSection4");
        this.engineTxt5 = EnderIO.lang.localize("gui.powerMonitor.engineSection5");
        this.engineTxt6 = EnderIO.lang.localize("gui.powerMonitor.engineSection6");
        this.monHeading1 = EnderIO.lang.localize("gui.powerMonitor.monHeading1");
        this.monHeading2 = EnderIO.lang.localize("gui.powerMonitor.monHeading2");
        this.monHeading3 = EnderIO.lang.localize("gui.powerMonitor.monHeading3");
        this.monHeading4 = EnderIO.lang.localize("gui.powerMonitor.monHeading4");
        this.monHeading5 = EnderIO.lang.localize("gui.powerMonitor.monHeading5");
        this.addToolTip(new GuiToolTip(new Rectangle(185, 9, 10, 130), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(PowerDisplayUtil.formatPower(te.getEnergyStored()) + "/" + PowerDisplayUtil.formatPower(te.getMaxEnergyStored()) + " " + PowerDisplayUtil.abrevation());
            }
        });
        int x = 7 + Minecraft.getMinecraft().fontRenderer.getStringWidth(this.titleStr) + 6;
        this.enabledB = new CheckBox((IGuiScreen)this, 21267, x, 8);
        this.enabledB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.enabled")});
        this.enabledB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.disabled")});
        this.enabledB.setSelected(te.engineControlEnabled);
        x = 7 + this.getFontRenderer().getStringWidth(this.engineTxt2) + 4;
        int y = 39 + this.getFontRenderer().FONT_HEIGHT;
        this.startTF = new TextFieldEnder(this.getFontRenderer(), x, y, 28, 14);
        this.startTF.setCanLoseFocus(true);
        this.startTF.setMaxStringLength(3);
        this.startTF.setVisible(false);
        this.startTF.setText(INT_NF.format(te.asPercentInt(te.startLevel)));
        y = y + this.getFontRenderer().FONT_HEIGHT + 16 + 16 + 4;
        x = 12 + this.getFontRenderer().getStringWidth(this.engineTxt5);
        this.endTF = new TextFieldEnder(this.getFontRenderer(), x, y, 28, 14);
        this.endTF.setCanLoseFocus(true);
        this.endTF.setMaxStringLength(3);
        this.endTF.setVisible(false);
        this.endTF.setText(INT_NF.format(te.asPercentInt(te.stopLevel)));
        this.textFields.add(this.startTF);
        this.textFields.add(this.endTF);
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        if (this.isRedstoneMode) {
            this.enabledB.onGuiInit();
        }
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public int getOverlayOffsetX() {
        return 0;
    }

    protected void mouseClicked(int x, int y, int par3) {
        super.mouseClicked(x, y, par3);
        y -= this.guiTop;
        if ((x -= this.guiLeft) > 200 && x < 220) {
            if (y >= 6 && y < 30) {
                this.isRedstoneMode = false;
                this.enabledB.detach();
                this.startTF.setVisible(false);
                this.endTF.setVisible(false);
            } else if (y >= 36 && y < 60) {
                this.isRedstoneMode = true;
                this.enabledB.onGuiInit();
                this.startTF.setVisible(true);
                this.endTF.setVisible(true);
            }
        }
    }

    protected void drawGuiContainerBackgroundLayer(float ptick, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)"enderio:textures/gui/powerMonitor.png");
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        int i1 = this.te.getEnergyStoredScaled(130);
        this.drawTexturedModalRect(sx + 185, sy + 139 - i1, 245, 0, 10, i1);
        this.renderRedstoneTab(sx, sy);
        this.renderInfoTab(sx, sy);
        this.checkForModifications();
        super.drawGuiContainerBackgroundLayer(ptick, mouseX, mouseY);
    }

    private void checkForModifications() {
        if (this.enabledB.isSelected() != this.te.engineControlEnabled || this.getInt((GuiTextField)this.startTF) != this.te.asPercentInt(this.te.startLevel) || this.getInt((GuiTextField)this.endTF) != this.te.asPercentInt(this.te.stopLevel)) {
            this.te.engineControlEnabled = this.enabledB.isSelected();
            int i = this.getInt((GuiTextField)this.startTF);
            if (i >= 0) {
                this.te.startLevel = this.te.asPercentFloat(i);
            }
            if ((i = this.getInt((GuiTextField)this.endTF)) >= 0) {
                this.te.stopLevel = this.te.asPercentFloat(i);
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPowerMonitor(this.te));
        }
    }

    private int getInt(GuiTextField tf) {
        String txt = tf.getText();
        if (txt == null) {
            return -1;
        }
        try {
            int val = Integer.parseInt(tf.getText());
            if (val >= 0 && val <= 100) {
                return val;
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private void renderRedstoneTab(int sx, int sy) {
        if (this.isRedstoneMode) {
            int left;
            IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)(sx + 200), (double)(sy + 30 + 6), true);
            itemRender.renderItemIntoGUI(this.fontRendererObj, this.mc.renderEngine, new ItemStack(Items.redstone), sx + 201, sy + 30 + 6 + 3);
            GL11.glDisable((int)2896);
            int x = left = this.guiLeft + 7;
            int y = this.guiTop + 7 + 6;
            int rgb = !this.enabledB.isSelected() ? ColorUtil.getRGB((Color)Color.darkGray) : ColorUtil.getRGB((Color)Color.black);
            FontRenderer fontRenderer = this.getFontRenderer();
            fontRenderer.drawString(this.titleStr, x, y, rgb, false);
            x = left + fontRenderer.getStringWidth(this.titleStr) + 6 + 16 + 6;
            y = this.guiTop + 14;
            if (!this.enabledB.isSelected()) {
                rgb = ColorUtil.getRGB((Color)Color.darkGray);
                this.enabledB.drawButton(this.mc, this.guiLeft, this.guiTop);
            } else {
                rgb = ColorUtil.getRGB((Color)Color.black);
            }
            this.enabledB.drawButton(this.mc, this.guiLeft, this.guiTop);
            x = left;
            String txt = this.engineTxt1;
            fontRenderer.drawString(txt, x, y += 22, rgb, false);
            x = left;
            txt = this.engineTxt2;
            fontRenderer.drawString(txt, x, y += 6 + fontRenderer.FONT_HEIGHT, rgb, false);
            x = left + fontRenderer.getStringWidth(txt) + 6 + this.startTF.getWidth() + 12;
            txt = this.engineTxt3;
            fontRenderer.drawString(txt, x, y, rgb, false);
            x = left;
            txt = this.engineTxt4;
            fontRenderer.drawString(txt, x, y += 16 + fontRenderer.FONT_HEIGHT + 6, rgb, false);
            x = left;
            txt = this.engineTxt5;
            fontRenderer.drawString(txt, x, y += 6 + fontRenderer.FONT_HEIGHT, rgb, false);
            x += fontRenderer.getStringWidth(txt);
            txt = this.engineTxt3;
            fontRenderer.drawString(txt, x += 7 + this.endTF.getWidth() + 10, y, rgb, false);
        } else {
            IconEIO.map.render((IWidgetIcon)IconEIO.INACTIVE_TAB, (double)(sx + 200), (double)(sy + 30 + 6), true);
            itemRender.renderItemIntoGUI(this.fontRendererObj, this.mc.renderEngine, new ItemStack(Items.redstone), sx + 201, sy + 30 + 6 + 3);
        }
    }

    private void renderInfoTab(int sx, int sy) {
        if (!this.isRedstoneMode) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)(sx + 200), (double)(sy + 6), true);
            int headingCol = ColorUtil.getRGB((Color)Color.white);
            int valuesCol = ColorUtil.getRGB((Color)Color.black);
            int x = this.guiLeft + 7;
            int y = this.guiTop + 7;
            int sectionGap = 6;
            FontRenderer fontRenderer = this.getFontRenderer();
            int rgb = headingCol;
            StringBuilder sb = new StringBuilder();
            sb.append(this.monHeading1);
            fontRenderer.drawString(sb.toString(), x, y, rgb, true);
            rgb = valuesCol;
            y += fontRenderer.FONT_HEIGHT + 2;
            sb = new StringBuilder();
            sb.append(PowerDisplayUtil.formatPower(this.te.powerInConduits));
            sb.append(" ");
            sb.append(PowerDisplayUtil.ofStr());
            sb.append(" ");
            sb.append(PowerDisplayUtil.formatPower(this.te.maxPowerInConduits));
            sb.append(" ");
            sb.append(PowerDisplayUtil.abrevation());
            fontRenderer.drawString(sb.toString(), x, y, rgb, false);
            rgb = headingCol;
            sb = new StringBuilder();
            sb.append(this.monHeading2);
            fontRenderer.drawString(sb.toString(), x, y += fontRenderer.FONT_HEIGHT + sectionGap, rgb, true);
            rgb = valuesCol;
            y += fontRenderer.FONT_HEIGHT + 2;
            sb = new StringBuilder();
            sb.append(PowerDisplayUtil.formatPower(this.te.powerInCapBanks));
            sb.append(" ");
            sb.append(PowerDisplayUtil.ofStr());
            sb.append(" ");
            sb.append(PowerDisplayUtil.formatPower(this.te.maxPowerInCapBanks));
            sb.append(" ");
            sb.append(PowerDisplayUtil.abrevation());
            fontRenderer.drawString(sb.toString(), x, y, rgb, false);
            rgb = headingCol;
            sb = new StringBuilder();
            sb.append(this.monHeading3);
            fontRenderer.drawString(sb.toString(), x, y += fontRenderer.FONT_HEIGHT + sectionGap, rgb, true);
            rgb = valuesCol;
            y += fontRenderer.FONT_HEIGHT + 2;
            sb = new StringBuilder();
            sb.append(PowerDisplayUtil.formatPower(this.te.powerInMachines));
            sb.append(" ");
            sb.append(PowerDisplayUtil.ofStr());
            sb.append(" ");
            sb.append(PowerDisplayUtil.formatPower(this.te.maxPowerInMachines));
            sb.append(" ");
            sb.append(PowerDisplayUtil.abrevation());
            fontRenderer.drawString(sb.toString(), x, y, rgb, false);
            rgb = headingCol;
            sb = new StringBuilder();
            sb.append(this.monHeading4);
            fontRenderer.drawString(sb.toString(), x, y += fontRenderer.FONT_HEIGHT + sectionGap, rgb, true);
            rgb = valuesCol;
            y += fontRenderer.FONT_HEIGHT + 2;
            sb = new StringBuilder();
            sb.append(PowerDisplayUtil.formatPowerFloat(this.te.aveRfSent));
            sb.append(" ");
            sb.append(PowerDisplayUtil.abrevation());
            sb.append(PowerDisplayUtil.perTickStr());
            fontRenderer.drawString(sb.toString(), x, y, rgb, false);
            rgb = headingCol;
            sb = new StringBuilder();
            sb.append(this.monHeading5);
            fontRenderer.drawString(sb.toString(), x, y += fontRenderer.FONT_HEIGHT + sectionGap, rgb, true);
            rgb = valuesCol;
            y += fontRenderer.FONT_HEIGHT + 2;
            sb = new StringBuilder();
            sb.append(PowerDisplayUtil.formatPowerFloat(this.te.aveRfReceived));
            sb.append(" ");
            sb.append(PowerDisplayUtil.abrevation());
            sb.append(PowerDisplayUtil.perTickStr());
            fontRenderer.drawString(sb.toString(), x, y, rgb, false);
        } else {
            IconEIO.map.render((IWidgetIcon)IconEIO.INACTIVE_TAB, (double)(sx + 200), (double)(sy + 6), true);
        }
    }
}

