/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.monitor;

import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.ContainerNoInv;
import crazypants.enderio.machine.monitor.GuiPowerMonitor;
import crazypants.enderio.machine.monitor.PacketPowerInfo;
import crazypants.enderio.machine.monitor.PacketPowerMonitor;
import crazypants.enderio.machine.monitor.TilePowerMonitor;
import crazypants.enderio.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPowerMonitor
extends AbstractMachineBlock<TilePowerMonitor> {
    public static BlockPowerMonitor create() {
        PacketHandler.INSTANCE.registerMessage(PacketPowerMonitor.class, PacketPowerMonitor.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketPowerInfo.class, PacketPowerInfo.class, PacketHandler.nextID(), Side.CLIENT);
        BlockPowerMonitor result = new BlockPowerMonitor();
        result.init();
        return result;
    }

    protected BlockPowerMonitor() {
        super(ModObject.blockPowerMonitor, TilePowerMonitor.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TilePowerMonitor) {
            return new ContainerNoInv((IInventory)((TilePowerMonitor)te));
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TilePowerMonitor) {
            return new GuiPowerMonitor(player.inventory, (TilePowerMonitor)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 8;
    }

    public boolean canProvidePower() {
        return true;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        return "enderio:powerMonitor";
    }

    public int isProvidingWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TilePowerMonitor) {
            return ((TilePowerMonitor)te).getRednetOutputValue(ForgeDirection.values()[side], DyeColor.RED.ordinal());
        }
        return 0;
    }
}

