/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.light;

import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.light.TileElectricLight;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileLightNode
extends TileEntityEio {
    int parentX;
    int parentY;
    int parentZ;

    public TileElectricLight getParent() {
        TileEntity te = this.worldObj.getTileEntity(this.parentX, this.parentY, this.parentZ);
        if (te instanceof TileElectricLight) {
            return (TileElectricLight)te;
        }
        return null;
    }

    protected boolean shouldUpdate() {
        return false;
    }

    public void checkParent() {
        if (this.worldObj.blockExists(this.parentX, this.parentY, this.parentZ) && this.worldObj.getBlock(this.parentX, this.parentY, this.parentZ) != EnderIO.blockElectricLight) {
            this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public void onNeighbourChanged() {
        TileElectricLight p = this.getParent();
        if (p != null) {
            p.nodeNeighbourChanged(this);
        }
    }

    public void onBlockRemoved() {
        TileElectricLight p = this.getParent();
        if (p != null) {
            p.nodeRemoved(this);
        }
    }

    public void readCustomNBT(NBTTagCompound root) {
        this.parentX = root.getInteger("parentX");
        this.parentY = root.getInteger("parentY");
        this.parentZ = root.getInteger("parentZ");
    }

    public void writeCustomNBT(NBTTagCompound root) {
        root.setInteger("parentX", this.parentX);
        root.setInteger("parentY", this.parentY);
        root.setInteger("parentZ", this.parentZ);
    }

    public String toString() {
        return "TileLightNode [parentX=" + this.parentX + ", parentY=" + this.parentY + ", parentZ=" + this.parentZ + ",  xCoord=" + this.xCoord + ", yCoord=" + this.yCoord + ", zCoord=" + this.zCoord + ", tileEntityInvalid=" + this.tileEntityInvalid + "]";
    }
}

