/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.killera;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.machine.generator.zombie.ModelZombieJar;
import crazypants.enderio.machine.killera.TileKillerJoe;
import crazypants.enderio.tool.SmartTank;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class KillerJoeRenderer
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private static final String TEXTURE = "enderio:models/KillerJoe.png";
    private static final ItemStack DEFAULT_SWORD = new ItemStack(Items.iron_sword);
    private ModelZombieJar model = new ModelZombieJar();

    public void renderTileEntityAt(TileEntity te, double x, double y, double z, float tick) {
        World world = te.getWorldObj();
        TileKillerJoe gen = (TileKillerJoe)te;
        float swingProg = gen.getSwingProgress(tick);
        float f = world.getBlockLightValue(te.xCoord, te.yCoord, te.zCoord);
        int l = world.getLightBrightnessForSkyBlocks(te.xCoord, te.yCoord, te.zCoord, 0);
        int l1 = l % 65536;
        int l2 = l / 65536;
        Tessellator.instance.setColorOpaque_F(f, f, f);
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)l1, (float)l2);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.renderModel(gen.facing);
        this.renderSword(gen.facing, gen.getStackInSlot(0), swingProg);
        this.renderFluid(gen);
        GL11.glPopMatrix();
    }

    private void renderSword(int facing, ItemStack sword, float swingProgress) {
        if (sword == null || sword.getIconIndex() == null) {
            return;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)facing);
        if (dir == ForgeDirection.SOUTH) {
            facing = 0;
        } else if (dir == ForgeDirection.WEST) {
            facing = -1;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        float offset = 90.0f;
        if (dir.offsetX != 0) {
            offset *= -1.0f;
        }
        GL11.glRotatef((float)((float)facing * -90.0f + offset), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        GL11.glPushMatrix();
        if (swingProgress > 0.0f) {
            float f6 = MathHelper.sin((float)(swingProgress * swingProgress * (float)Math.PI));
            float f7 = MathHelper.sin((float)(MathHelper.sqrt_float((float)swingProgress) * (float)Math.PI));
            GL11.glRotatef((float)(f6 * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(f7 * 50.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glTranslatef((float)-0.255f, (float)0.2f, (float)0.05f);
        RenderUtil.bindItemTexture();
        IIcon icon = sword.getIconIndex();
        float f9 = 0.0625f;
        float minU = icon.getMinU();
        float maxU = icon.getMaxU();
        float minV = icon.getMinV();
        float maxV = icon.getMaxV();
        ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)f9);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected void renderFluid(TileKillerJoe gen) {
        SmartTank tank = gen.fuelTank;
        if (tank.getFluidAmount() <= 0) {
            return;
        }
        IIcon icon = tank.getFluid().getFluid().getStillIcon();
        if (icon != null) {
            RenderUtil.bindBlockTexture();
            Tessellator tes = Tessellator.instance;
            tes.startDrawingQuads();
            float fullness = (float)tank.getFluidAmount() / (float)tank.getCapacity();
            BoundingBox bb = BoundingBox.UNIT_CUBE.scale(0.85, 0.96, 0.85);
            bb = bb.scale(1.0, 0.85 * (double)fullness, 1.0);
            float ty = -(0.85f - (bb.maxY - bb.minY)) / 2.0f;
            Vector3d offset = ForgeDirectionOffsets.offsetScaled((ForgeDirection)ForgeDirection.values()[gen.facing], (double)-0.075);
            bb = bb.translate((float)offset.x, ty, (float)offset.z);
            int brightness = gen.getWorldObj() == null ? 0xF000F0 : gen.getWorldObj().getLightBrightnessForSkyBlocks(gen.xCoord, gen.yCoord, gen.zCoord, 0);
            tes.setBrightness(brightness);
            tes.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            CubeRenderer.render((BoundingBox)bb, (IIcon)icon);
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            tes.draw();
            GL11.glDepthMask((boolean)true);
            GL11.glPopAttrib();
        }
    }

    private void renderModel(int facing) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)1.2f, (float)0.9f, (float)1.2f);
        ForgeDirection dir = ForgeDirection.getOrientation((int)facing);
        if (dir == ForgeDirection.SOUTH) {
            facing = 0;
        } else if (dir == ForgeDirection.WEST) {
            facing = -1;
        }
        GL11.glRotatef((float)((float)facing * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtil.bindTexture((String)TEXTURE);
        this.model.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        GL11.glPopMatrix();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.renderItem(0.0f, 0.0f, 0.0f);
    }

    private void renderItem(float x, float y, float z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.renderModel(ForgeDirection.EAST.ordinal());
        this.renderSword(ForgeDirection.EAST.ordinal(), DEFAULT_SWORD, 0.0f);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

