/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.killera;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.SoundUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.gui.GuiMachineBase;
import crazypants.enderio.machine.killera.ContainerKillerJoe;
import crazypants.enderio.machine.killera.TileKillerJoe;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.ExperienceBarRenderer;
import crazypants.enderio.xp.PacketGivePlayerXP;
import java.awt.Rectangle;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;

public class GuiKillerJoe
extends GuiMachineBase<TileKillerJoe> {
    private static final int XP_ID = 3489;
    private static final int XP10_ID = 34892;
    private IconButton xpB;
    private IconButton xp10B;

    public GuiKillerJoe(InventoryPlayer inventory, final TileKillerJoe tileEntity) {
        super(tileEntity, (Container)new ContainerKillerJoe(inventory, tileEntity));
        this.addToolTip(new GuiToolTip(new Rectangle(18, 11, 15, 47), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("killerJoe.fuelTank");
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileKillerJoe)((GuiKillerJoe)GuiKillerJoe.this).getTileEntity()).fuelTank));
                if (tileEntity.fuelTank.getFluidAmount() < tileEntity.getActivationAmount()) {
                    this.text.add(EnderIO.lang.localize("gui.fluid.minReq", new Object[]{tileEntity.getActivationAmount() + Fluids.MB()}));
                }
            }
        });
        this.xpB = new IconButton((IGuiScreen)this, 3489, 128, 56, (IWidgetIcon)IconEIO.XP);
        this.xpB.setToolTip(new String[]{EnderIO.lang.localize("killerJoe.giveXp.tooltip")});
        this.xp10B = new IconButton((IGuiScreen)this, 34892, 148, 56, (IWidgetIcon)IconEIO.XP_PLUS);
        this.xp10B.setToolTip(new String[]{EnderIO.lang.localize("killerJoe.giveXp10.tooltip")});
    }

    @Override
    public void initGui() {
        super.initGui();
        this.xpB.onGuiInit();
        this.xp10B.onGuiInit();
    }

    protected void actionPerformed(GuiButton b) {
        super.actionPerformed(b);
        if (b.id == 3489) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGivePlayerXP((TileEntity)this.getTileEntity(), 1));
            SoundUtil.playClientSoundFX((String)"random.orb", this.getTileEntity());
        } else if (b.id == 34892) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGivePlayerXP((TileEntity)this.getTileEntity(), 10));
            SoundUtil.playClientSoundFX((String)"random.orb", this.getTileEntity());
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        super.renderSlotHighlights(mode);
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            int x = 16;
            int y = 9;
            int w = 19;
            int h = 51;
            this.renderSlotHighlight(PULL_COLOR, x, y, w, h);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)"enderio:textures/gui/killerJoe.png");
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        int x = this.guiLeft + 18;
        int y = this.guiTop + 11;
        TileKillerJoe joe = (TileKillerJoe)this.getTileEntity();
        if (joe.fuelTank.getFluidAmount() > 0) {
            RenderUtil.renderGuiTank((FluidStack)joe.fuelTank.getFluid(), (int)joe.fuelTank.getCapacity(), (int)joe.fuelTank.getFluidAmount(), (double)x, (double)y, (double)this.zLevel, (double)16.0, (double)47.0);
        }
        ExperienceBarRenderer.render((Gui)this, sx + 56, sy + 62, 65, joe.getContainer());
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
    }
}

