/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.killera;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.killera.ContainerKillerJoe;
import crazypants.enderio.machine.killera.GuiKillerJoe;
import crazypants.enderio.machine.killera.PacketSwing;
import crazypants.enderio.machine.killera.TileKillerJoe;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.PacketGivePlayerXP;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class BlockKillerJoe
extends AbstractMachineBlock<TileKillerJoe> {
    static final String USERNAME = "KillerJoe";

    public static BlockKillerJoe create() {
        PacketHandler.INSTANCE.registerMessage(PacketSwing.class, PacketSwing.class, PacketHandler.nextID(), Side.CLIENT);
        PacketGivePlayerXP.register();
        PacketExperianceContainer.register();
        BlockKillerJoe res = new BlockKillerJoe();
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected BlockKillerJoe() {
        super(ModObject.blockKillerJoe, TileKillerJoe.class);
        this.setStepSound(Block.soundTypeGlass);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return 2000.0f;
    }

    @SubscribeEvent
    public void getKillDisplayName(PlayerEvent.NameFormat nameEvt) {
        if (nameEvt.username != null && nameEvt.username.startsWith(USERNAME)) {
            nameEvt.displayname = this.getLocalizedName();
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerKillerJoe(player.inventory, (TileKillerJoe)world.getTileEntity(x, y, z));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiKillerJoe(player.inventory, (TileKillerJoe)world.getTileEntity(x, y, z));
    }

    @Override
    protected int getGuiId() {
        return 92;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        return "enderio:blankMachinePanel";
    }

    @Override
    public int getRenderType() {
        return -1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    protected short getFacingForHeading(int heading) {
        switch (heading) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
        }
        return 5;
    }
}

