/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.server;

import com.enderio.core.common.network.CompressedDataInput;
import com.enderio.core.common.network.CompressedDataOutput;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.invpanel.InventoryDatabase;
import crazypants.enderio.machine.invpanel.PacketDatabaseReset;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.server.AbstractInventory;
import crazypants.enderio.machine.invpanel.server.ChangeLog;
import crazypants.enderio.machine.invpanel.server.ChangeLogList;
import crazypants.enderio.machine.invpanel.server.InventoryFactory;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import crazypants.enderio.network.PacketHandler;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryDatabaseServer
extends InventoryDatabase<ItemEntry> {
    private static final AtomicInteger nextGeneration = new AtomicInteger();
    private final ItemConduitNetwork network;
    private int networkChangeCount;
    private AbstractInventory[] inventories;
    private int currentInventory;
    private ChangeLog changeLog;
    private boolean sentToClient;
    private int tickPause;
    private float power;

    public InventoryDatabaseServer(ItemConduitNetwork network) {
        this.network = network;
    }

    public ItemConduitNetwork getNetwork() {
        return this.network;
    }

    public boolean isCurrent() {
        return this.networkChangeCount == this.network.getChangeCount();
    }

    public void addChangeLog(ChangeLog cl) {
        if (this.changeLog == null) {
            this.changeLog = cl;
        } else if (this.changeLog instanceof ChangeLogList) {
            ((ChangeLogList)this.changeLog).add(cl);
        } else if (this.changeLog != cl) {
            this.changeLog = new ChangeLogList(this.changeLog, cl);
        }
    }

    public void removeChangeLog(ChangeLog cl) {
        if (this.changeLog == cl) {
            this.changeLog = null;
        } else if (this.changeLog instanceof ChangeLogList) {
            this.changeLog = ((ChangeLogList)this.changeLog).remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ItemEntry> decompressMissingItems(byte[] compressed) throws IOException {
        CompressedDataInput cdi = new CompressedDataInput(compressed);
        try {
            int pktGeneration = cdi.readVariable();
            if (pktGeneration != this.generation) {
                List<ItemEntry> list = Collections.emptyList();
                return list;
            }
            int numIDs = cdi.readVariable();
            ArrayList<ItemEntry> items = new ArrayList<ItemEntry>(numIDs);
            for (int i = 0; i < numIDs; ++i) {
                int dbIndex = cdi.readVariable();
                if (dbIndex >= this.complexItems.size()) continue;
                ItemEntry entry = (ItemEntry)this.complexItems.get(dbIndex);
                items.add(entry);
            }
            ArrayList<ItemEntry> arrayList = items;
            return arrayList;
        }
        finally {
            cdi.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compressItemInfo(List<ItemEntry> items) throws IOException {
        CompressedDataOutput cdo = new CompressedDataOutput();
        try {
            int count = items.size();
            cdo.writeVariable(count);
            for (ItemEntry entry : items) {
                assert (entry.dbID >= 65536);
                int code = entry.dbID - 65536 << 1;
                if (entry.nbt != null) {
                    code |= 1;
                }
                cdo.writeVariable(code);
                cdo.writeVariable(entry.itemID);
                cdo.writeVariable(entry.meta);
                if (entry.nbt != null) {
                    CompressedStreamTools.write((NBTTagCompound)entry.nbt, (DataOutput)cdo);
                }
                cdo.writeVariable(entry.countItems(this));
            }
            Object object = cdo.getCompressed();
            return object;
        }
        finally {
            cdo.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compressItemList() throws IOException {
        CompressedDataOutput cdo = new CompressedDataOutput();
        try {
            cdo.writeByte(0);
            for (Map.Entry entry : this.simpleRegsitry.entrySet()) {
                int count = ((ItemEntry)entry.getValue()).countItems(this);
                if (count <= 0) continue;
                cdo.writeVariable(count);
                cdo.writeShort(((Integer)entry.getKey()).intValue());
            }
            cdo.writeByte(0);
            int prevID = 65536;
            for (ItemEntry entry : this.complexItems) {
                int count;
                if (entry == null || (count = entry.countItems(this)) <= 0) continue;
                cdo.writeVariable(count);
                cdo.writeVariable(entry.dbID - prevID);
                prevID = entry.dbID;
            }
            cdo.writeByte(0);
            this.sentToClient = true;
            Object object = cdo.getCompressed();
            return object;
        }
        finally {
            cdo.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compressChangedItems(Collection<ItemEntry> items) throws IOException {
        CompressedDataOutput cdo = new CompressedDataOutput();
        try {
            cdo.writeVariable(items.size());
            for (ItemEntry entry : items) {
                cdo.writeVariable(entry.dbID);
                cdo.writeVariable(entry.countItems(this));
            }
            Object object = cdo.getCompressed();
            return object;
        }
        finally {
            cdo.close();
        }
    }

    public void resetDatabase() {
        this.simpleRegsitry.clear();
        this.complexRegistry.clear();
        this.complexItems.clear();
        this.currentInventory = 0;
        if (this.sentToClient) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketDatabaseReset(this.generation));
            this.sentToClient = false;
        }
    }

    public void updateNetworkSources() {
        this.resetDatabase();
        this.generation = nextGeneration.incrementAndGet();
        this.networkChangeCount = this.network.getChangeCount();
        List<NetworkedInventory> sources = this.network.getInventoryPanelSources();
        if (sources == null || sources.isEmpty()) {
            this.inventories = null;
        } else {
            this.inventories = new AbstractInventory[sources.size()];
            for (int i = 0; i < sources.size(); ++i) {
                NetworkedInventory ni = sources.get(i);
                this.inventories[i] = InventoryFactory.createInventory(ni);
            }
        }
        if (this.changeLog != null) {
            this.changeLog.databaseReset();
        }
    }

    public int getNumInventories() {
        return this.inventories == null ? 0 : this.inventories.length;
    }

    public float getPower() {
        return this.power;
    }

    public void addPower(float power) {
        this.power += power;
    }

    public boolean isOperational() {
        return this.power > 0.0f && this.inventories != null;
    }

    public int extractItems(ItemEntry entry, int count, TileInventoryPanel te) {
        float availablePower = this.power + te.getAvailablePower();
        if ((availablePower -= Config.inventoryPanelExtractCostPerOperation) <= 0.0f) {
            return 0;
        }
        if (Config.inventoryPanelExtractCostPerOperation > 0.0f) {
            long maxCount = Math.round(Math.floor(availablePower / Config.inventoryPanelExtractCostPerOperation));
            count = (int)Math.min(maxCount, (long)count);
        }
        if (count > 0) {
            int extracted = entry.extractItems(this, count);
            this.power -= Config.inventoryPanelExtractCostPerOperation + (float)extracted * Config.inventoryPanelExtractCostPerOperation;
            te.refuelPower(this);
            return extracted;
        }
        return 0;
    }

    private void scanNextInventory() {
        if (!this.isOperational()) {
            this.tickPause = 20;
            return;
        }
        AbstractInventory inv = this.inventories[this.currentInventory];
        int slots = inv.scanInventory(this);
        this.currentInventory = (this.currentInventory + 1) % this.inventories.length;
        this.tickPause += 1 + (slots + 8) / 9;
        this.power -= (float)slots * Config.inventoryPanelScanCostPerSlot;
    }

    public void tick() {
        if (--this.tickPause <= 0) {
            this.scanNextInventory();
        }
    }

    void entryChanged(ItemEntry entry) {
        if (this.changeLog != null) {
            this.changeLog.entryChanged(entry);
        }
    }

    public void sendChangeLogs() {
        if (this.changeLog != null) {
            this.changeLog.sendChangeLog();
        }
    }

    @Override
    protected ItemEntry createItemEntry(int dbId, int hash, int itemID, int meta, NBTTagCompound nbt) {
        return new ItemEntry(dbId, hash, itemID, meta, nbt);
    }

    AbstractInventory getInventory(int aiIndex) {
        return this.inventories[aiIndex];
    }
}

