/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.client;

import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.machine.invpanel.ItemEntryBase;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class ItemEntry
extends ItemEntryBase {
    String name;
    String modId;
    String lowerCaseLocName;
    int count;

    public ItemEntry(int dbID, int hash, int itemID, int meta, NBTTagCompound nbt) {
        super(dbID, hash, itemID, meta, nbt);
    }

    public int getCount() {
        return this.count;
    }

    public ItemStack makeItemStack() {
        ItemStack stack = new ItemStack(this.getItem(), this.count, this.meta);
        stack.stackTagCompound = this.nbt;
        return stack;
    }

    public String getUnlocName() {
        if (this.name == null) {
            this.findUnlocName();
        }
        return this.name;
    }

    public String getLowercaseUnlocName(Locale locale) {
        if (this.lowerCaseLocName == null) {
            this.lowerCaseLocName = StatCollector.translateToLocal((String)this.getUnlocName()).toLowerCase(locale);
        }
        return this.lowerCaseLocName;
    }

    private void findUnlocName() {
        ItemStack stack = this.makeItemStack();
        try {
            this.name = stack.getDisplayName();
            if (this.name == null || this.name.isEmpty()) {
                this.name = stack.getItem().getUnlocalizedName();
                if (this.name == null || this.name.isEmpty()) {
                    this.name = stack.getItem().getClass().getName();
                }
            }
        }
        catch (Throwable ex) {
            this.name = "Exception: " + ex.getMessage();
        }
    }

    public String getModId() {
        if (this.modId == null) {
            this.findModId();
        }
        return this.modId;
    }

    private void findModId() {
        Item item = this.getItem();
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)item);
        this.modId = id != null && id.modId != null ? id.modId : "Unknown";
    }
}

