/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.client;

import com.enderio.core.common.network.CompressedDataInput;
import crazypants.enderio.machine.invpanel.InventoryDatabase;
import crazypants.enderio.machine.invpanel.client.ItemEntry;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryDatabaseClient
extends InventoryDatabase<ItemEntry> {
    private final ArrayList<ItemEntry> clientItems;
    private final HashSet<Integer> requestedItems;
    private int itemsChangeCount;
    private int countChangeCount;

    InventoryDatabaseClient(int generation) {
        this.generation = generation;
        this.clientItems = new ArrayList();
        this.requestedItems = new HashSet();
    }

    public int getItemsChangeCount() {
        return this.itemsChangeCount;
    }

    public int getCountChangeCount() {
        return this.countChangeCount;
    }

    public void getItems(List<ItemEntry> outList) {
        outList.addAll(this.clientItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCompressedItems(byte[] compressed) throws IOException {
        CompressedDataInput cdi = new CompressedDataInput(compressed);
        try {
            int numEntries = cdi.readVariable();
            for (int i = 0; i < numEntries; ++i) {
                int code = cdi.readVariable();
                int itemID = cdi.readVariable();
                int meta = cdi.readVariable();
                NBTTagCompound nbt = null;
                int dbIndex = code >> 1;
                if ((code & 1) == 1) {
                    nbt = CompressedStreamTools.read((DataInputStream)cdi);
                }
                this.complexItems.ensureCapacity(dbIndex + 1);
                while (this.complexItems.size() <= dbIndex) {
                    this.complexItems.add(null);
                }
                ItemEntry entry = (ItemEntry)this.complexItems.get(dbIndex);
                if (entry == null) {
                    entry = (ItemEntry)this.createItemEntry(dbIndex + 65536, itemID, meta, nbt);
                    this.complexItems.set(dbIndex, entry);
                    this.complexRegistry.put(entry, entry);
                }
                int count = cdi.readVariable();
                this.setItemCount(entry, count);
            }
            ++this.itemsChangeCount;
            ++this.countChangeCount;
        }
        finally {
            cdi.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> readCompressedItemList(byte[] compressed) throws IOException {
        CompressedDataInput cdi = new CompressedDataInput(compressed);
        try {
            List<Integer> missingItems = null;
            int changed = cdi.readVariable();
            if (changed > 0) {
                for (int i = 0; i < changed; ++i) {
                    int dbID = cdi.readVariable();
                    int count = cdi.readVariable();
                    ItemEntry entry = (ItemEntry)this.getItem(dbID);
                    if (entry != null) {
                        this.setItemCount(entry, count);
                        continue;
                    }
                    missingItems = this.addMissingItems(missingItems, dbID);
                }
                ++this.countChangeCount;
            } else {
                ItemEntry entry;
                for (ItemEntry entry2 : this.clientItems) {
                    entry2.count = 0;
                }
                this.clientItems.clear();
                this.requestedItems.clear();
                int count = cdi.readVariable();
                while (count > 0) {
                    int dbID = cdi.readUnsignedShort();
                    entry = (ItemEntry)this.getSimpleItem(dbID);
                    entry.count = count;
                    this.clientItems.add(entry);
                    count = cdi.readVariable();
                }
                count = cdi.readVariable();
                int dbID = 65536;
                while (count > 0) {
                    entry = (ItemEntry)this.getItem(dbID += cdi.readVariable());
                    if (entry != null) {
                        entry.count = count;
                        this.clientItems.add(entry);
                    } else {
                        missingItems = this.addMissingItems(missingItems, dbID);
                    }
                    count = cdi.readVariable();
                }
                ++this.itemsChangeCount;
                ++this.countChangeCount;
            }
            List<Integer> list = missingItems;
            return list;
        }
        finally {
            cdi.close();
        }
    }

    private void setItemCount(ItemEntry entry, int count) {
        if (entry.count == 0 && count > 0) {
            this.clientItems.add(entry);
            ++this.itemsChangeCount;
        } else if (entry.count > 0 && count == 0) {
            this.clientItems.remove(entry);
            ++this.itemsChangeCount;
        }
        entry.count = count;
    }

    private List<Integer> addMissingItems(List<Integer> list, Integer dbId) {
        if (!this.requestedItems.contains(dbId)) {
            if (list == null) {
                list = new ArrayList<Integer>();
            }
            list.add(dbId);
            this.requestedItems.add(dbId);
        }
        return list;
    }

    @Override
    protected ItemEntry createItemEntry(int dbId, int hash, int itemID, int meta, NBTTagCompound nbt) {
        return new ItemEntry(dbId, hash, itemID, meta, nbt);
    }
}

