/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StoredCraftingRecipe {
    private final ItemStack[] slots = new ItemStack[9];
    private boolean updateResult;
    private ItemStack result;

    public boolean loadFromCraftingGrid(List<Slot> craftingGrid) {
        if (craftingGrid.size() != 9) {
            return false;
        }
        int count = 0;
        for (int slotIdx = 0; slotIdx < 9 && slotIdx < craftingGrid.size(); ++slotIdx) {
            Slot slot = craftingGrid.get(slotIdx);
            ItemStack stack = slot.getStack();
            if (stack == null) continue;
            stack = stack.copy();
            stack.stackSize = 1;
            this.slots[slotIdx] = stack;
            ++count;
        }
        return count > 0;
    }

    public ItemStack get(int index) {
        return this.slots[index];
    }

    public boolean isEqual(List<Slot> craftingGrid) {
        for (int slotIdx = 0; slotIdx < 9; ++slotIdx) {
            ItemStack a = this.slots[slotIdx];
            ItemStack b = craftingGrid.get(slotIdx).getStack();
            if (a == null && b == null || ItemUtil.areStacksEqual((ItemStack)a, (ItemStack)b)) continue;
            return false;
        }
        return true;
    }

    public void writeToNBT(NBTTagCompound nbtRoot) {
        for (int slotIdx = 0; slotIdx < 9; ++slotIdx) {
            ItemStack itemStack = this.slots[slotIdx];
            if (itemStack == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStack.writeToNBT(itemStackNBT);
            nbtRoot.setTag(Integer.toString(slotIdx), (NBTBase)itemStackNBT);
        }
    }

    public boolean readFromNBT(NBTTagCompound nbtRoot) {
        boolean hasSlots = false;
        for (int slotIdx = 0; slotIdx < 9; ++slotIdx) {
            NBTTagCompound itemStackNBT = (NBTTagCompound)nbtRoot.getTag(Integer.toString(slotIdx));
            if (itemStackNBT != null) {
                this.slots[slotIdx] = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemStackNBT);
                hasSlots = true;
                continue;
            }
            this.slots[slotIdx] = null;
        }
        this.updateResult = true;
        this.result = null;
        return hasSlots;
    }

    public ItemStack getResult(TileInventoryPanel te) {
        if (this.updateResult) {
            this.findCraftingResult(te);
        }
        return this.result;
    }

    private void findCraftingResult(TileInventoryPanel te) {
        InventoryCrafting tmp = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer ep) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            tmp.setInventorySlotContents(i, this.slots[i]);
        }
        this.result = CraftingManager.getInstance().findMatchingRecipe(tmp, te.getWorldObj());
        if (this.result != null) {
            this.result = this.result.copy();
            this.result.stackSize = 1;
        }
        this.updateResult = false;
    }
}

