/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.network.MessageTileEntity;
import com.enderio.core.common.network.NetworkUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.invpanel.PacketItemInfo;
import crazypants.enderio.machine.invpanel.PacketRequestMissingItems;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketItemList
extends MessageTileEntity<TileInventoryPanel>
implements IMessageHandler<PacketItemList, IMessage> {
    private int generation;
    private byte[] compressed;

    public PacketItemList() {
    }

    public PacketItemList(TileInventoryPanel tile, int generation, byte[] compressed) {
        super((TileEntity)tile);
        this.generation = generation;
        this.compressed = compressed;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.generation = buf.readInt();
        this.compressed = NetworkUtil.readByteArray((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.generation);
        NetworkUtil.writeByteArray((ByteBuf)buf, (byte[])this.compressed);
    }

    public IMessage onMessage(PacketItemList message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        TileEntity te = player.worldObj.getTileEntity(message.x, message.y, message.z);
        if (te instanceof TileInventoryPanel) {
            TileInventoryPanel teInvPanel = (TileInventoryPanel)te;
            InventoryDatabaseClient db = teInvPanel.getDatabaseClient(message.generation);
            try {
                List<Integer> missingItems = db.readCompressedItemList(message.compressed);
                if (missingItems != null) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestMissingItems(teInvPanel, db.getGeneration(), missingItems));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PacketItemInfo.class.getName()).log(Level.SEVERE, "Exception while reading item list", ex);
            }
        }
        return null;
    }
}

