/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.machine.gui.AbstractMachineContainer;
import crazypants.enderio.machine.invpanel.PacketItemList;
import crazypants.enderio.machine.invpanel.PacketMoveItems;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.server.ChangeLog;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import crazypants.enderio.network.PacketHandler;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class InventoryPanelContainer
extends AbstractMachineContainer<TileInventoryPanel>
implements ChangeLog {
    public static final int CRAFTING_GRID_X = 31;
    public static final int CRAFTING_GRID_Y = 16;
    public static final int RETURN_INV_X = 31;
    public static final int RETURN_INV_Y = 82;
    public static final int FILTER_SLOT_X = 257;
    public static final int FILTER_SLOT_Y = 7;
    private final HashSet<ItemEntry> changedItems;
    private Slot slotFilter;
    private int slotCraftResult;
    private int firstSlotReturn;
    private int endSlotReturn;
    private int firstSlotCraftingGrid;
    private int endSlotCraftingGrid;
    private boolean updateReturnAreaSlots;
    private boolean storedRecipeExists;

    public InventoryPanelContainer(InventoryPlayer playerInv, TileInventoryPanel te) {
        super(playerInv, te);
        te.eventHandler = this;
        this.changedItems = te.getWorldObj().isRemote ? null : new HashSet();
    }

    @Override
    protected void addMachineSlots(InventoryPlayer playerInv) {
        int x;
        int y;
        this.slotCraftResult = this.inventorySlots.size();
        this.addSlotToContainer((Slot)new SlotCrafting(playerInv.player, this.getInv(), this.getInv(), 9, 90, 34){

            public void onPickupFromSlot(EntityPlayer player, ItemStack p_82870_2_) {
                FMLCommonHandler.instance().firePlayerCraftingEvent(player, p_82870_2_, InventoryPanelContainer.this.getInv());
                for (int i = 0; i < 9; ++i) {
                    ItemStack itemstack = ((TileInventoryPanel)InventoryPanelContainer.this.getInv()).getStackInSlot(i);
                    if (itemstack == null) continue;
                    ((TileInventoryPanel)InventoryPanelContainer.this.getInv()).decrStackSize(i, 1);
                    if (!itemstack.getItem().hasContainerItem(itemstack)) continue;
                    ItemStack containerIS = itemstack.getItem().getContainerItem(itemstack);
                    if (containerIS != null && containerIS.isItemStackDamageable() && containerIS.getItemDamage() > containerIS.getMaxDamage()) {
                        MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, containerIS));
                        continue;
                    }
                    if (itemstack.getItem().doesContainerItemLeaveCraftingGrid(itemstack) && (ItemUtil.doInsertItem((IInventory)InventoryPanelContainer.this.getInv(), (int)10, (int)20, (ItemStack)itemstack) > 0 || player.inventory.addItemStackToInventory(containerIS))) continue;
                    if (((TileInventoryPanel)InventoryPanelContainer.this.getInv()).getStackInSlot(i) == null) {
                        ((TileInventoryPanel)InventoryPanelContainer.this.getInv()).setInventorySlotContents(i, containerIS);
                        continue;
                    }
                    player.dropPlayerItemWithRandomChoice(containerIS, false);
                }
            }
        });
        this.firstSlotCraftingGrid = this.inventorySlots.size();
        int i = 0;
        for (y = 0; y < 3; ++y) {
            x = 0;
            while (x < 3) {
                this.addSlotToContainer(new Slot(this.getInv(), i, 31 + x * 18, 16 + y * 18));
                ++x;
                ++i;
            }
        }
        this.endSlotCraftingGrid = this.inventorySlots.size();
        this.slotFilter = this.addSlotToContainer(new Slot(this.getInv(), 10, 257, 7){

            public int getSlotStackLimit() {
                return 1;
            }
        });
        this.firstSlotReturn = this.inventorySlots.size();
        i = 11;
        for (y = 0; y < 2; ++y) {
            x = 0;
            while (x < 5) {
                this.addSlotToContainer(new Slot(this.getInv(), i, 31 + x * 18, 82 + y * 18));
                ++x;
                ++i;
            }
        }
        this.endSlotReturn = this.inventorySlots.size();
    }

    @Override
    public Point getPlayerInventoryOffset() {
        return new Point(63, 130);
    }

    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        if (!((TileInventoryPanel)this.getInv()).getWorldObj().isRemote) {
            ((TileInventoryPanel)this.getInv()).eventHandler = null;
        }
        this.removeChangeLog();
    }

    public TileInventoryPanel getInventoryPanel() {
        return (TileInventoryPanel)this.getInv();
    }

    public Slot getSlotFilter() {
        return this.slotFilter;
    }

    public List<Slot> getCraftingGridSlots() {
        return this.inventorySlots.subList(this.firstSlotCraftingGrid, this.endSlotCraftingGrid);
    }

    public List<Slot> getReturnAreaSlots() {
        return this.inventorySlots.subList(this.firstSlotReturn, this.endSlotReturn);
    }

    public List<Slot> getPlayerInventorySlots() {
        return this.inventorySlots.subList(this.startPlayerSlot, this.endPlayerSlot);
    }

    public List<Slot> getPlayerHotbarSlots() {
        return this.inventorySlots.subList(this.startHotBarSlot, this.endHotBarSlot);
    }

    private void removeChangeLog() {
        InventoryDatabaseServer db;
        if (this.changedItems != null && (db = this.getInventoryPanel().getDatabaseServer()) != null) {
            db.removeChangeLog(this);
        }
    }

    public void removeCraftingFromCrafters(ICrafting crafting) {
        super.removeCraftingFromCrafters(crafting);
        this.removeChangeLog();
    }

    public void addCraftingToCrafters(ICrafting crafting) {
        InventoryDatabaseServer db;
        if (this.changedItems != null) {
            this.sendChangeLog();
        }
        super.addCraftingToCrafters(crafting);
        if (this.changedItems != null && (db = this.getInventoryPanel().getDatabaseServer()) != null) {
            db.addChangeLog(this);
            if (crafting instanceof EntityPlayerMP) {
                try {
                    byte[] compressed = db.compressItemList();
                    PacketItemList pil = new PacketItemList(this.getInventoryPanel(), db.getGeneration(), compressed);
                    PacketHandler.sendTo((IMessage)pil, (EntityPlayerMP)crafting);
                }
                catch (IOException ex) {
                    Logger.getLogger(InventoryPanelContainer.class.getName()).log(Level.SEVERE, "Exception while compressing item list", ex);
                }
            }
        }
    }

    public void onCraftMatrixChanged(IInventory inv) {
        InventoryCrafting tmp = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer ep) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            tmp.setInventorySlotContents(i, ((TileInventoryPanel)this.getInv()).getStackInSlot(i));
        }
        ((TileInventoryPanel)this.getInv()).setInventorySlotContents(9, CraftingManager.getInstance().findMatchingRecipe(tmp, ((TileInventoryPanel)this.getInv()).getWorldObj()));
        this.checkCraftingRecipes();
    }

    public void checkCraftingRecipes() {
        this.storedRecipeExists = false;
        int storedCraftingRecipes = this.getInventoryPanel().getStoredCraftingRecipes();
        if (this.hasCraftingRecipe() && storedCraftingRecipes > 0) {
            List<Slot> craftingGrid = this.getCraftingGridSlots();
            for (int idx = 0; idx < storedCraftingRecipes; ++idx) {
                if (!this.getInventoryPanel().getStoredCraftingRecipe(idx).isEqual(craftingGrid)) continue;
                this.storedRecipeExists = true;
                break;
            }
        }
    }

    public boolean func_94530_a(ItemStack par1, Slot slot) {
        return !(slot instanceof SlotCrafting) && super.func_94530_a(par1, slot);
    }

    public boolean clearCraftingGrid() {
        boolean cleared = true;
        for (Slot slot : this.getCraftingGridSlots()) {
            if (!slot.getHasStack()) continue;
            this.moveItemsToReturnArea(slot.slotNumber);
            if (!slot.getHasStack()) continue;
            cleared = false;
        }
        return cleared;
    }

    public boolean hasCraftingRecipe() {
        return this.getSlot(this.slotCraftResult).getHasStack();
    }

    public boolean hasNewCraftingRecipe() {
        return this.hasCraftingRecipe() && !this.storedRecipeExists;
    }

    @Override
    protected List<AbstractMachineContainer.SlotRange> getTargetSlotsForTransfer(int slotIndex, Slot slot) {
        if (slotIndex == this.slotCraftResult || slotIndex >= this.firstSlotReturn && slotIndex < this.endSlotReturn) {
            return Collections.singletonList(this.getPlayerInventorySlotRange(true));
        }
        if (slotIndex >= this.firstSlotCraftingGrid && slotIndex < this.endSlotCraftingGrid) {
            ArrayList<AbstractMachineContainer.SlotRange> res = new ArrayList<AbstractMachineContainer.SlotRange>();
            res.add(new AbstractMachineContainer.SlotRange(this.firstSlotReturn, this.endSlotReturn, false));
            res.add(this.getPlayerInventorySlotRange(false));
            return res;
        }
        if (slotIndex >= this.startPlayerSlot) {
            return Collections.singletonList(new AbstractMachineContainer.SlotRange(this.firstSlotReturn, this.endSlotReturn, false));
        }
        return Collections.emptyList();
    }

    protected boolean mergeItemStack(ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reversOrder) {
        if (!super.mergeItemStack(par1ItemStack, fromIndex, toIndex, reversOrder)) {
            return false;
        }
        if (fromIndex < this.endSlotReturn && toIndex > this.firstSlotReturn) {
            this.updateReturnAreaSlots = true;
        }
        return true;
    }

    public void detectAndSendChanges() {
        if (this.updateReturnAreaSlots) {
            this.updateReturnAreaSlots = false;
            this.sendReturnAreaSlots();
        }
        super.detectAndSendChanges();
    }

    private void sendReturnAreaSlots() {
        for (int slotIdx = this.firstSlotReturn; slotIdx < this.endSlotReturn; ++slotIdx) {
            ItemStack stack = ((Slot)this.inventorySlots.get(slotIdx)).getStack();
            if (stack != null) {
                stack = stack.copy();
            }
            this.inventoryItemStacks.set(slotIdx, stack);
            for (Object crafter : this.crafters) {
                ((ICrafting)crafter).sendSlotContents((Container)this, slotIdx, stack);
            }
        }
    }

    @Override
    public void entryChanged(ItemEntry entry) {
        this.changedItems.add(entry);
    }

    @Override
    public void databaseReset() {
        this.changedItems.clear();
    }

    @Override
    public void sendChangeLog() {
        InventoryDatabaseServer db;
        if (!this.changedItems.isEmpty() && !this.crafters.isEmpty() && (db = this.getInventoryPanel().getDatabaseServer()) != null) {
            try {
                byte[] compressed = db.compressChangedItems(this.changedItems);
                PacketItemList pil = new PacketItemList(this.getInventoryPanel(), db.getGeneration(), compressed);
                for (Object crafting : this.crafters) {
                    if (!(crafting instanceof EntityPlayerMP)) continue;
                    PacketHandler.sendTo((IMessage)pil, (EntityPlayerMP)crafting);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(InventoryPanelContainer.class.getName()).log(Level.SEVERE, "Exception while compressing changed items", ex);
            }
        }
        this.changedItems.clear();
    }

    public int getSlotIndex(IInventory inv, int index) {
        for (int i = 0; i < this.inventorySlots.size(); ++i) {
            Slot slot = (Slot)this.inventorySlots.get(i);
            if (!slot.isSlotInInventory(inv, index)) continue;
            return i;
        }
        return -1;
    }

    public void executeFetchItems(EntityPlayerMP player, int generation, int dbID, int targetSlot, int count) {
        TileInventoryPanel te = this.getInventoryPanel();
        InventoryDatabaseServer db = te.getDatabaseServer();
        if (db == null || db.getGeneration() != generation || !db.isCurrent()) {
            return;
        }
        ItemEntry entry = (ItemEntry)db.getExistingItem(dbID);
        if (entry != null) {
            int extracted;
            int maxStackSize;
            ItemStack targetStack;
            Slot slot;
            if (targetSlot < 0) {
                slot = null;
                targetStack = player.inventory.getItemStack();
                maxStackSize = player.inventory.getInventoryStackLimit();
            } else {
                slot = this.getSlot(targetSlot);
                targetStack = slot.getStack();
                maxStackSize = slot.getSlotStackLimit();
            }
            ItemStack tmpStack = new ItemStack(entry.getItem(), 0, entry.meta);
            tmpStack.stackTagCompound = entry.nbt;
            maxStackSize = Math.min(maxStackSize, tmpStack.getMaxStackSize());
            if (targetStack != null && targetStack.stackSize > 0) {
                if (!ItemUtil.areStackMergable((ItemStack)tmpStack, (ItemStack)targetStack)) {
                    return;
                }
            } else {
                targetStack = tmpStack.copy();
            }
            if ((count = Math.min(count, maxStackSize - targetStack.stackSize)) > 0 && (extracted = db.extractItems(entry, count, te)) > 0) {
                targetStack.stackSize += extracted;
                this.sendChangeLog();
                if (slot != null) {
                    slot.putStack(targetStack);
                } else {
                    player.inventory.setItemStack(targetStack);
                    player.updateHeldItem();
                }
            }
        }
    }

    public boolean moveItemsToReturnArea(int fromSlot) {
        return this.moveItems(fromSlot, this.firstSlotReturn, this.endSlotReturn, Short.MAX_VALUE);
    }

    public boolean moveItems(int fromSlot, int toSlotStart, int toSlotEnd, int amount) {
        if (!this.executeMoveItems(fromSlot, toSlotStart, toSlotEnd, amount)) {
            return false;
        }
        if (((TileInventoryPanel)this.getInv()).getWorldObj().isRemote) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMoveItems(fromSlot, toSlotStart, toSlotEnd, amount));
        }
        return true;
    }

    public boolean executeMoveItems(int fromSlot, int toSlotStart, int toSlotEnd, int amount) {
        if (fromSlot >= toSlotStart && fromSlot < toSlotEnd || toSlotEnd <= toSlotStart || amount <= 0) {
            return false;
        }
        Slot srcSlot = this.getSlot(fromSlot);
        ItemStack src = srcSlot.getStack();
        if (src != null) {
            ItemStack toMove = src.copy();
            toMove.stackSize = Math.min(src.stackSize, amount);
            int remaining = src.stackSize - toMove.stackSize;
            if (this.mergeItemStack(toMove, toSlotStart, toSlotEnd, false)) {
                if ((remaining += toMove.stackSize) == 0) {
                    srcSlot.putStack(null);
                } else {
                    src.stackSize = remaining;
                    srcSlot.onSlotChanged();
                }
                return true;
            }
        }
        return false;
    }
}

