/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ClientProxy;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.invpanel.BlockItemInventoryPanel;
import crazypants.enderio.machine.invpanel.GuiInventoryPanel;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import crazypants.enderio.machine.invpanel.PacketDatabaseReset;
import crazypants.enderio.machine.invpanel.PacketFetchItem;
import crazypants.enderio.machine.invpanel.PacketGuiSettings;
import crazypants.enderio.machine.invpanel.PacketItemInfo;
import crazypants.enderio.machine.invpanel.PacketItemList;
import crazypants.enderio.machine.invpanel.PacketMoveItems;
import crazypants.enderio.machine.invpanel.PacketRequestMissingItems;
import crazypants.enderio.machine.invpanel.PacketSetExtractionDisabled;
import crazypants.enderio.machine.invpanel.PacketStoredCraftingRecipe;
import crazypants.enderio.machine.invpanel.PacketUpdateExtractionDisabled;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.network.PacketHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInventoryPanel
extends AbstractMachineBlock<TileInventoryPanel> {
    private static final float BLOCK_SIZE = 0.1875f;

    public static BlockInventoryPanel create() {
        PacketHandler.INSTANCE.registerMessage(PacketItemInfo.class, PacketItemInfo.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketItemList.class, PacketItemList.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketRequestMissingItems.class, PacketRequestMissingItems.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketFetchItem.class, PacketFetchItem.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketMoveItems.class, PacketMoveItems.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketDatabaseReset.class, PacketDatabaseReset.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketGuiSettings.class, PacketGuiSettings.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketStoredCraftingRecipe.class, PacketStoredCraftingRecipe.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketSetExtractionDisabled.class, PacketSetExtractionDisabled.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpdateExtractionDisabled.class, PacketUpdateExtractionDisabled.class, PacketHandler.nextID(), Side.CLIENT);
        BlockInventoryPanel panel = new BlockInventoryPanel();
        panel.init();
        return panel;
    }

    public BlockInventoryPanel() {
        super(ModObject.blockInventoryPanel, TileInventoryPanel.class);
    }

    @Override
    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemInventoryPanel.class, (String)this.modObject.unlocalisedName);
        GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.modObject.unlocalisedName + "TileEntity"));
        EnderIO.guiHandler.registerGuiHandler(this.getGuiId(), this);
    }

    @Override
    public int getRenderType() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isBlockSolid(IBlockAccess world, int x, int y, int z, int blockSide) {
        int facing = this.getFacing(world, x, y, z);
        return ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing] == 2;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean isBlockNormalCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.40625f, 1.0f, 1.0f, 0.59375f);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return this.getBoundingBox((IBlockAccess)world, x, y, z);
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return this.getBoundingBox((IBlockAccess)world, x, y, z);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        AxisAlignedBB bb = this.getBoundingBox(0, 0, 0, this.getFacing(world, x, y, z));
        this.setBlockBounds(bb);
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, int x, int y, int z) {
        int facing = this.getFacing(world, x, y, z);
        return this.getBoundingBox(x, y, z, facing);
    }

    public AxisAlignedBB getBoundingBox(int x, int y, int z, int facing) {
        switch (facing) {
            case 0: {
                return AxisAlignedBB.getBoundingBox((double)x, (double)((float)y + 0.8125f), (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case 1: {
                return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)y + 0.1875f), (double)(z + 1));
            }
            case 2: {
                return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)((float)z + 0.8125f), (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case 3: {
                return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)((float)z + 0.1875f));
            }
            case 4: {
                return AxisAlignedBB.getBoundingBox((double)((float)x + 0.8125f), (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            }
            case 5: {
                return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)((float)x + 0.1875f), (double)(y + 1), (double)(z + 1));
            }
        }
        return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    private int getFacing(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileInventoryPanel) {
            return ((TileInventoryPanel)te).getFacing();
        }
        return 0;
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
    }

    @Override
    protected int getGuiId() {
        return 105;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:invPanelFrontOn";
        }
        return "enderio:invPanelFrontOff";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int blockSide, int blockMeta) {
        return this.iconBuffer[0][blockSide + 6];
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileInventoryPanel) {
            return new InventoryPanelContainer(player.inventory, (TileInventoryPanel)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileInventoryPanel te = (TileInventoryPanel)world.getTileEntity(x, y, z);
        return new GuiInventoryPanel(te, (Container)new InventoryPanelContainer(player.inventory, te));
    }
}

