/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketStoredPower
implements IMessage,
IMessageHandler<PacketStoredPower, IMessage> {
    private int x;
    private int y;
    private int z;
    private int storedEnergy;

    public PacketStoredPower() {
    }

    public PacketStoredPower(TileHyperCube ent) {
        this.x = ent.xCoord;
        this.y = ent.yCoord;
        this.z = ent.zCoord;
        this.storedEnergy = ent.getEnergyStored();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.storedEnergy);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.storedEnergy = buf.readInt();
    }

    public IMessage onMessage(PacketStoredPower message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        TileEntity te = player.worldObj.getTileEntity(message.x, message.y, message.z);
        if (te instanceof TileHyperCube) {
            TileHyperCube me = (TileHyperCube)te;
            me.setEnergyStored(message.storedEnergy);
        }
        return null;
    }
}

