/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import com.enderio.core.common.util.PlayerUtil;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketClientState
implements IMessage,
IMessageHandler<PacketClientState, IMessage> {
    private int x;
    private int y;
    private int z;
    private List<TileHyperCube.IoMode> modes;
    private Channel selectedChannel;

    public PacketClientState() {
    }

    public PacketClientState(TileHyperCube te) {
        this.x = te.xCoord;
        this.y = te.yCoord;
        this.z = te.zCoord;
        this.modes = new ArrayList<TileHyperCube.IoMode>(TileHyperCube.SubChannel.values().length);
        for (TileHyperCube.SubChannel sc : TileHyperCube.SubChannel.values()) {
            this.modes.add(te.getModeForChannel(sc));
        }
        this.selectedChannel = te.getChannel();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        if (this.selectedChannel == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.selectedChannel.name);
            if (this.selectedChannel.isPublic()) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)"");
            } else {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.selectedChannel.user.toString());
            }
        }
        for (TileHyperCube.IoMode mode : this.modes) {
            buf.writeShort(mode.ordinal());
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        String user = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.selectedChannel = null;
        if (name != null && name.trim().length() > 0) {
            this.selectedChannel = user != null && user.trim().length() > 0 ? new Channel(name, PlayerUtil.getPlayerUIDUnstable((String)user)) : new Channel(name, null);
        }
        this.modes = new ArrayList<TileHyperCube.IoMode>(TileHyperCube.SubChannel.values().length);
        for (TileHyperCube.SubChannel sc : TileHyperCube.SubChannel.values()) {
            short ordinal = buf.readShort();
            this.modes.add(TileHyperCube.IoMode.values()[ordinal]);
        }
    }

    public IMessage onMessage(PacketClientState message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().playerEntity;
        TileEntity te = player.worldObj.getTileEntity(message.x, message.y, message.z);
        if (te instanceof TileHyperCube) {
            TileHyperCube hc = (TileHyperCube)te;
            TileHyperCube.SubChannel[] vals = TileHyperCube.SubChannel.values();
            for (int i = 0; i < vals.length; ++i) {
                TileHyperCube.SubChannel sc = vals[i];
                TileHyperCube.IoMode mode = message.modes.get(i);
                hc.setModeForChannel(sc, mode);
            }
            hc.setChannel(message.selectedChannel);
            player.worldObj.markBlockForUpdate(message.x, message.y, message.z);
        }
        return null;
    }
}

