/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import com.enderio.core.common.util.InventoryWrapper;
import crazypants.enderio.ModObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class CompositeInventory
implements ISidedInventory {
    private final List<InvEntry> inventories = new ArrayList<InvEntry>();
    private int size = 0;

    public void addInventory(CompositeInventory inv) {
        for (InvEntry ie : inv.inventories) {
            this.addInventory((IInventory)ie.inv, ie.side);
        }
    }

    public void addInventory(IInventory inv, ForgeDirection side) {
        if (inv == null) {
            return;
        }
        this.inventories.add(new InvEntry(inv, this.size, side));
        this.updateSize();
    }

    public void removeInventory(IInventory inv) {
        if (inv == null) {
            return;
        }
        InvEntry remove = null;
        for (InvEntry ie : this.inventories) {
            if (ie.inv != inv && ie.origInv != inv) continue;
            remove = ie;
            break;
        }
        if (remove != null) {
            this.inventories.remove(remove);
            this.updateSize();
        }
    }

    private void updateSize() {
        this.size = 0;
        for (InvEntry inv : this.inventories) {
            if (inv == null || inv.inv == null) continue;
            inv.startIndex = this.size;
            inv.endIndex = inv.startIndex + inv.inv.getSizeInventory() - 1;
            this.size += inv.inv.getSizeInventory();
        }
    }

    public int getSizeInventory() {
        return this.size;
    }

    public ItemStack getStackInSlot(int i) {
        for (InvEntry inv : this.inventories) {
            if (!inv.containsSlot(i)) continue;
            return inv.inv.getStackInSlot(inv.getSlot(i));
        }
        return null;
    }

    public ItemStack decrStackSize(int slot, int j) {
        for (InvEntry inv : this.inventories) {
            if (!inv.containsSlot(slot)) continue;
            return inv.inv.decrStackSize(inv.getSlot(slot), j);
        }
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack itemStack) {
        for (InvEntry inv : this.inventories) {
            if (!inv.containsSlot(slot)) continue;
            inv.inv.setInventorySlotContents(inv.getSlot(slot), itemStack);
            return;
        }
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        ArrayList<Integer> resList = new ArrayList<Integer>();
        for (InvEntry inv : this.inventories) {
            int[] slots = inv.inv.getAccessibleSlotsFromSide(inv.side.ordinal());
            if (slots == null) continue;
            for (int i = 0; i < slots.length; ++i) {
                resList.add(slots[i]);
            }
        }
        int[] result = new int[resList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)resList.get(i);
        }
        return result;
    }

    public boolean canInsertItem(int slot, ItemStack item, int side) {
        for (InvEntry inv : this.inventories) {
            if (inv == null || !inv.containsSlot(slot)) continue;
            return inv.inv.canInsertItem(inv.getSlot(slot), item, side);
        }
        return false;
    }

    public boolean canExtractItem(int slot, ItemStack item, int side) {
        for (InvEntry inv : this.inventories) {
            if (inv == null || !inv.containsSlot(slot)) continue;
            return inv.inv.canExtractItem(inv.getSlot(slot), item, side);
        }
        return false;
    }

    public boolean isItemValidForSlot(int slot, ItemStack item) {
        for (InvEntry inv : this.inventories) {
            if (inv == null || !inv.containsSlot(slot)) continue;
            return inv.inv.isItemValidForSlot(inv.getSlot(slot), item);
        }
        return false;
    }

    public void markDirty() {
        for (InvEntry inv : this.inventories) {
            if (inv == null) continue;
            inv.inv.markDirty();
        }
    }

    public String getInventoryName() {
        return ModObject.blockHyperCube.unlocalisedName;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    private static class InvEntry {
        IInventory origInv;
        ISidedInventory inv;
        int startIndex;
        int endIndex;
        ForgeDirection side;

        InvEntry(IInventory inventory, int startIndex, ForgeDirection side) {
            this.origInv = inventory;
            this.inv = InventoryWrapper.asSidedInventory((IInventory)inventory);
            this.endIndex = startIndex + this.inv.getSizeInventory() - 1;
            this.side = side;
        }

        boolean containsSlot(int index) {
            return index >= this.startIndex && index <= this.endIndex;
        }

        int getSlot(int index) {
            return index - this.startIndex;
        }
    }
}

