/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.PlayerUtil;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.ConnectionHandler;
import crazypants.enderio.machine.hypercube.ContainerHyperCube;
import crazypants.enderio.machine.hypercube.GuiHyperCube;
import crazypants.enderio.machine.hypercube.ItemRecieveBuffer;
import crazypants.enderio.machine.hypercube.PacketAddRemoveChannel;
import crazypants.enderio.machine.hypercube.PacketChannelList;
import crazypants.enderio.machine.hypercube.PacketClientState;
import crazypants.enderio.machine.hypercube.PacketStoredPower;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerHandlerUtil;
import java.text.NumberFormat;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHyperCube
extends BlockEio
implements IGuiHandler,
IResourceTooltipProvider {
    static final NumberFormat NF = NumberFormat.getIntegerInstance();

    public static BlockHyperCube create() {
        PacketHandler.INSTANCE.registerMessage(PacketChannelList.class, PacketChannelList.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketClientState.class, PacketClientState.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketAddRemoveChannel.class, PacketAddRemoveChannel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketAddRemoveChannel.class, PacketAddRemoveChannel.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketStoredPower.class, PacketStoredPower.class, PacketHandler.nextID(), Side.CLIENT);
        BlockHyperCube result = new BlockHyperCube();
        result.init();
        ConnectionHandler ch = new ConnectionHandler();
        FMLCommonHandler.instance().bus().register((Object)ch);
        MinecraftForge.EVENT_BUS.register((Object)ch);
        return result;
    }

    private BlockHyperCube() {
        super(ModObject.blockHyperCube.unlocalisedName, TileHyperCube.class);
        this.setCreativeTab(null);
    }

    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(7, this);
    }

    public IIcon getPortalIcon() {
        return this.blockIcon;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister IIconRegister2) {
        this.blockIcon = IIconRegister2.registerIcon("enderio:tesseractPortal");
    }

    public int getRenderType() {
        return -1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 8;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        if (world.isRemote) {
            return;
        }
        TileHyperCube tr = (TileHyperCube)world.getTileEntity(x, y, z);
        tr.onBlockAdded();
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block blockId) {
        if (world.isRemote) {
            return;
        }
        TileHyperCube te = (TileHyperCube)world.getTileEntity(x, y, z);
        te.onNeighborBlockChange();
    }

    private void setChannelOnItem(TileHyperCube hc, ItemStack itemStack) {
        Channel chan = hc.getChannel();
        if (chan != null) {
            NBTTagCompound tag = itemStack.getTagCompound();
            if (tag == null) {
                tag = new NBTTagCompound();
                itemStack.setTagCompound(tag);
            }
            tag.setString("channelName", chan.name);
            tag.setBoolean("channelIsPublic", chan.isPublic());
            if (!chan.isPublic()) {
                tag.setString("channelUser", chan.user.toString());
            }
        }
    }

    private void setIoOnItem(TileHyperCube hc, ItemStack itemStack) {
        NBTTagCompound tag = itemStack.getTagCompound();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.setTagCompound(tag);
        }
        for (TileHyperCube.SubChannel sc : TileHyperCube.SubChannel.values()) {
            tag.setShort("sendRecieve" + sc.ordinal(), (short)hc.getModeForChannel(sc).ordinal());
        }
    }

    private void setIoOnTransciever(TileHyperCube hc, ItemStack itemStack) {
        NBTTagCompound tag = itemStack.getTagCompound();
        if (tag == null) {
            return;
        }
        for (TileHyperCube.SubChannel sc : TileHyperCube.SubChannel.values()) {
            if (!tag.hasKey("sendRecieve" + sc.ordinal())) continue;
            hc.setModeForChannel(sc, TileHyperCube.IoMode.values()[tag.getShort("sendRecieve" + sc.ordinal())]);
        }
    }

    private Channel getChannelFromItem(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.getTagCompound();
        if (tag == null) {
            return null;
        }
        String channelName = tag.getString("channelName");
        if (channelName == null || channelName.trim().isEmpty()) {
            return null;
        }
        UUID user = null;
        if (!tag.getBoolean("channelIsPublic")) {
            user = PlayerUtil.getPlayerUIDUnstable((String)tag.getString("channelUser"));
        }
        return new Channel(channelName, user);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity te;
        if (!world.isRemote && (te = world.getTileEntity(x, y, z)) instanceof TileHyperCube) {
            TileHyperCube hc = (TileHyperCube)te;
            hc.onBreakBlock();
            ItemStack itemStack = new ItemStack((Block)this);
            PowerHandlerUtil.setStoredEnergyForItem(itemStack, hc.getEnergyStored());
            this.setChannelOnItem(hc, itemStack);
            this.setIoOnItem(hc, itemStack);
            float f = 0.7f;
            double d0 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, itemStack);
            entityitem.delayBeforeCanPickup = 10;
            world.spawnEntityInWorld((Entity)entityitem);
            ItemRecieveBuffer rb = hc.getRecieveBuffer();
            Util.dropItems((World)world, (IInventory)rb, (int)x, (int)y, (int)z, (boolean)true);
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        if (world.isRemote) {
            return;
        }
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileHyperCube) {
            TileHyperCube cb = (TileHyperCube)te;
            cb.setEnergyStored(PowerHandlerUtil.getStoredEnergyForItem(stack));
            if (player instanceof EntityPlayerMP) {
                cb.setOwner(PlayerUtil.getPlayerUUID((String)((EntityPlayerMP)player).getGameProfile().getName()));
            }
            cb.setChannel(this.getChannelFromItem(stack));
            this.setIoOnTransciever(cb, stack);
        }
        world.markBlockForUpdate(x, y, z);
    }

    public int quantityDropped(Random r) {
        return 0;
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        if (!world.isRemote) {
            entityPlayer.openGui((Object)EnderIO.instance, 7, world, x, y, z);
        }
        return true;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerHyperCube();
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileHyperCube) {
            TileHyperCube hc = (TileHyperCube)te;
            return new GuiHyperCube(hc);
        }
        return null;
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.getUnlocalizedName();
    }
}

