/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.gui;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.util.Util;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class AbstractMachineContainer<T extends AbstractMachineEntity>
extends ContainerEnder<T> {
    protected Slot upgradeSlot;

    public AbstractMachineContainer(InventoryPlayer playerInv, T te) {
        super(playerInv, te);
    }

    protected void addSlots(InventoryPlayer playerInv) {
        this.addMachineSlots(playerInv);
        final AbstractMachineEntity te = (AbstractMachineEntity)this.getInv();
        if (te.getSlotDefinition().getNumUpgradeSlots() == 1) {
            this.upgradeSlot = new Slot((IInventory)te, te.getSlotDefinition().getMinUpgradeSlot(), this.getUpgradeOffset().x, this.getUpgradeOffset().y){

                public int getSlotStackLimit() {
                    return 1;
                }

                public boolean isItemValid(ItemStack itemStack) {
                    return te.isItemValidForSlot(te.getSlotDefinition().getMinUpgradeSlot(), itemStack);
                }
            };
            this.addSlotToContainer(this.upgradeSlot);
        }
    }

    public Point getPlayerInventoryOffset() {
        return new Point(8, 84);
    }

    public Point getUpgradeOffset() {
        return new Point(12, 60);
    }

    public Slot getUpgradeSlot() {
        return this.upgradeSlot;
    }

    protected abstract void addMachineSlots(InventoryPlayer var1);

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        SlotDefinition slotDef = ((AbstractMachineEntity)this.getInv()).getSlotDefinition();
        ItemStack copystack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack origStack = slot.getStack();
            copystack = origStack.copy();
            boolean merged = false;
            for (SlotRange range : this.getTargetSlotsForTransfer(slotIndex, slot)) {
                if (!this.mergeItemStack(origStack, range.start, range.end, range.reverse)) continue;
                merged = true;
                break;
            }
            if (!merged) {
                return null;
            }
            if (slotDef.isOutputSlot(slotIndex)) {
                slot.onSlotChange(origStack, copystack);
            }
            if (origStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
            if (origStack.stackSize == copystack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(entityPlayer, origStack);
        }
        return copystack;
    }

    protected int getIndexOfFirstPlayerInvSlot(SlotDefinition slotDef) {
        return slotDef.getNumSlots();
    }

    protected SlotRange getPlayerInventorySlotRange(boolean reverse) {
        return new SlotRange(this.startPlayerSlot, this.endHotBarSlot, reverse);
    }

    protected SlotRange getPlayerInventoryWithoutHotbarSlotRange() {
        return new SlotRange(this.startPlayerSlot, this.endPlayerSlot, false);
    }

    protected SlotRange getPlayerHotbarSlotRange() {
        return new SlotRange(this.startHotBarSlot, this.endHotBarSlot, false);
    }

    protected void addInventorySlotRange(List<SlotRange> res, int start, int end) {
        for (int i = start; i < end; ++i) {
            int slotNumber = this.getSlotFromInventory((IInventory)this.getInv(), (int)i).slotNumber;
            res.add(new SlotRange(slotNumber, slotNumber + 1, false));
        }
    }

    protected void addInputSlotRanges(List<SlotRange> res) {
        SlotDefinition slotDef = ((AbstractMachineEntity)this.getInv()).getSlotDefinition();
        if (slotDef.getNumInputSlots() > 0) {
            this.addInventorySlotRange(res, slotDef.getMinInputSlot(), slotDef.getMaxInputSlot() + 1);
        }
    }

    protected void addUpgradeSlotRanges(List<SlotRange> res) {
        SlotDefinition slotDef = ((AbstractMachineEntity)this.getInv()).getSlotDefinition();
        if (slotDef.getNumUpgradeSlots() > 0) {
            this.addInventorySlotRange(res, slotDef.getMinUpgradeSlot(), slotDef.getMaxUpgradeSlot() + 1);
        }
    }

    protected void addPlayerSlotRanges(List<SlotRange> res, int slotIndex) {
        if (slotIndex < this.endPlayerSlot) {
            res.add(this.getPlayerHotbarSlotRange());
        }
        if (slotIndex >= this.startHotBarSlot && slotIndex < this.endHotBarSlot) {
            res.add(this.getPlayerInventoryWithoutHotbarSlotRange());
        }
    }

    protected List<SlotRange> getTargetSlotsForTransfer(int slotIndex, Slot slot) {
        if (slot.inventory == this.getInv()) {
            SlotDefinition slotDef = ((AbstractMachineEntity)this.getInv()).getSlotDefinition();
            if (slotDef.isInputSlot(slot.slotNumber) || slotDef.isUpgradeSlot(slot.slotNumber)) {
                return Collections.singletonList(this.getPlayerInventorySlotRange(false));
            }
            if (slotDef.isOutputSlot(slot.slotNumber)) {
                return Collections.singletonList(this.getPlayerInventorySlotRange(true));
            }
        } else if (slotIndex >= this.startPlayerSlot) {
            ArrayList<SlotRange> res = new ArrayList<SlotRange>();
            this.addInputSlotRanges(res);
            this.addUpgradeSlotRanges(res);
            this.addPlayerSlotRanges(res, slotIndex);
            return res;
        }
        return Collections.emptyList();
    }

    protected int getProgressScaled(int scale) {
        if (this.getInv() instanceof IProgressTile) {
            Util.getProgressScaled((int)scale, (IProgressTile)((IProgressTile)this.getInv()));
        }
        return 0;
    }

    public static class SlotRange {
        final int start;
        final int end;
        final boolean reverse;

        public SlotRange(int start, int end, boolean reverse) {
            this.start = start;
            this.end = end;
            this.reverse = reverse;
        }
    }
}

