/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.generator.zombie.BubbleFX;
import crazypants.enderio.machine.generator.zombie.ContainerZombieGenerator;
import crazypants.enderio.machine.generator.zombie.GuiZombieGenerator;
import crazypants.enderio.machine.generator.zombie.TileZombieGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockZombieGenerator
extends AbstractMachineBlock<TileZombieGenerator> {
    public static BlockZombieGenerator create() {
        BlockZombieGenerator gen = new BlockZombieGenerator();
        gen.init();
        return gen;
    }

    protected BlockZombieGenerator() {
        super(ModObject.blockZombieGenerator, TileZombieGenerator.class, Material.anvil);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerZombieGenerator(player.inventory, (TileZombieGenerator)world.getTileEntity(x, y, z));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiZombieGenerator(player.inventory, (TileZombieGenerator)world.getTileEntity(x, y, z));
    }

    @Override
    protected int getGuiId() {
        return 71;
    }

    public int getLightOpacity() {
        return 0;
    }

    @Override
    public int getRenderType() {
        return -1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:stirlingGenFrontOn";
        }
        return "enderio:stirlingGenFrontOff";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        TileEntity te;
        if (rand.nextInt(3) == 0 && (te = world.getTileEntity(x, y, z)) instanceof TileZombieGenerator && ((TileZombieGenerator)te).isActive()) {
            for (int i = 0; i < 2; ++i) {
                float xOffset = 0.5f + (world.rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float yOffset = 0.1f;
                float zOffset = 0.5f + (world.rand.nextFloat() * 2.0f - 1.0f) * 0.3f;
                BubbleFX fx = new BubbleFX(world, (float)x + xOffset, (float)y + yOffset, (float)z + zOffset, 0.0, 0.5, 0.0);
                Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
            }
            if (Config.machineSoundsEnabled) {
                float volume = Config.machineSoundVolume * 0.045f;
                world.playSound((double)x + 0.5, (double)(y + 1), (double)z + 0.5, EnderIO.DOMAIN + ":generator.zombie.bubble", volume, world.rand.nextFloat() * 0.75f, false);
            }
        }
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te != null && te instanceof TileZombieGenerator) {
            tooltip.add(((TileZombieGenerator)te).getFluidStored(ForgeDirection.UNKNOWN) + " " + EnderIO.lang.localize("fluid.millibucket.abr"));
        }
    }
}

