/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeHarvestUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;

public class TreeFarmer
implements IFarmerJoe {
    private static final HeightComparator comp = new HeightComparator();
    protected Block sapling;
    protected ItemStack saplingItem;
    protected Block[] woods;
    protected TreeHarvestUtil harvester = new TreeHarvestUtil();
    private boolean ignoreMeta;

    public TreeFarmer(Block sapling, Block ... wood) {
        this.sapling = sapling;
        if (sapling != null) {
            this.saplingItem = new ItemStack(sapling);
        }
        this.woods = wood;
    }

    public TreeFarmer(boolean ignoreMeta, Block sapling, Block ... wood) {
        this(sapling, wood);
        this.ignoreMeta = ignoreMeta;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        return this.isWood(block);
    }

    protected boolean isWood(Block block) {
        for (Block wood : this.woods) {
            if (block != wood) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return stack != null && stack.getItem() == this.saplingItem.getItem();
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        if (block == this.sapling) {
            return true;
        }
        return this.plantFromInventory(farm, bc, block, meta);
    }

    protected boolean plantFromInventory(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        ItemStack seed;
        World worldObj = farm.getWorldObj();
        if (this.canPlant(worldObj, bc) && (seed = farm.takeSeedFromSupplies(this.saplingItem, bc, false)) != null) {
            return this.plant(farm, worldObj, bc, seed);
        }
        return false;
    }

    protected boolean canPlant(World worldObj, BlockCoord bc) {
        Block ground = worldObj.getBlock(bc.x, bc.y - 1, bc.z);
        IPlantable plantable = (IPlantable)this.sapling;
        return this.sapling.canPlaceBlockAt(worldObj, bc.x, bc.y, bc.z) && this.sapling.canBlockStay(worldObj, bc.x, bc.y, bc.z) && ground.canSustainPlant((IBlockAccess)worldObj, bc.x, bc.y - 1, bc.z, ForgeDirection.UP, plantable);
    }

    protected boolean plant(TileFarmStation farm, World worldObj, BlockCoord bc, ItemStack seed) {
        worldObj.setBlock(bc.x, bc.y, bc.z, Blocks.air, 0, 3);
        if (this.canPlant(worldObj, bc)) {
            worldObj.setBlock(bc.x, bc.y, bc.z, this.sapling, seed.getItemDamage(), 3);
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        boolean hasAxe = farm.hasAxe();
        if (!hasAxe) {
            return null;
        }
        HarvestResult res = new HarvestResult();
        this.harvester.harvest(farm, this, bc, res);
        Collections.sort(res.harvestedBlocks, comp);
        ArrayList<BlockCoord> actualHarvests = new ArrayList<BlockCoord>();
        boolean hasShears = farm.hasShears();
        int noShearingPercentage = farm.isLowOnSaplings(bc);
        int shearCount = 0;
        for (int i = 0; i < res.harvestedBlocks.size() && hasAxe; ++i) {
            ArrayList drops;
            BlockCoord coord = res.harvestedBlocks.get(i);
            Block blk = farm.getBlock(coord);
            boolean wasSheared = false;
            boolean wasAxed = false;
            boolean wasWood = this.isWood(blk);
            if (blk instanceof IShearable && hasShears && shearCount / res.harvestedBlocks.size() + noShearingPercentage < 100) {
                drops = ((IShearable)blk).onSheared(null, (IBlockAccess)farm.getWorldObj(), coord.x, coord.y, coord.z, 0);
                wasSheared = true;
                shearCount += 100;
            } else {
                drops = blk.getDrops(farm.getWorldObj(), coord.x, coord.y, coord.z, farm.getBlockMeta(coord), farm.getAxeLootingValue());
                wasAxed = true;
            }
            if (drops != null) {
                for (ItemStack drop : drops) {
                    res.drops.add(new EntityItem(farm.getWorldObj(), (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, drop.copy()));
                }
            }
            if (wasAxed && !wasWood) {
                wasAxed = Config.farmAxeDamageOnLeafBreak;
                int leaveMeta = farm.getBlockMeta(coord);
                if (TreeHarvestUtil.canDropApples(blk, leaveMeta) && farm.getWorldObj().rand.nextInt(200) == 0) {
                    res.drops.add(new EntityItem(farm.getWorldObj(), (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, new ItemStack(Items.apple)));
                }
            }
            farm.actionPerformed(wasWood || wasSheared);
            if (wasAxed) {
                farm.damageAxe(blk, coord);
                hasAxe = farm.hasAxe();
            } else if (wasSheared) {
                farm.damageShears(blk, coord);
                hasShears = farm.hasShears();
            }
            farm.getWorldObj().setBlockToAir(coord.x, coord.y, coord.z);
            actualHarvests.add(coord);
        }
        if (!hasAxe) {
            farm.setNotification("noAxe");
        }
        res.harvestedBlocks.clear();
        res.harvestedBlocks.addAll(actualHarvests);
        return res;
    }

    public boolean getIgnoreMeta() {
        return this.ignoreMeta;
    }

    private static class HeightComparator
    implements Comparator<BlockCoord> {
        private HeightComparator() {
        }

        @Override
        public int compare(BlockCoord o1, BlockCoord o2) {
            return HeightComparator.compare(o2.y, o1.y);
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

