/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.farm.farmers.CocoaFarmer;
import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.FlowerPicker;
import crazypants.enderio.machine.farm.farmers.ManaBeanFarmer;
import crazypants.enderio.machine.farm.farmers.MelonFarmer;
import crazypants.enderio.machine.farm.farmers.NaturaBerryFarmer;
import crazypants.enderio.machine.farm.farmers.NetherWartFarmer;
import crazypants.enderio.machine.farm.farmers.PickableFarmer;
import crazypants.enderio.machine.farm.farmers.PlantableFarmer;
import crazypants.enderio.machine.farm.farmers.RubberTreeFarmerIC2;
import crazypants.enderio.machine.farm.farmers.StemFarmer;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class FarmersRegistry {
    public static final PlantableFarmer DEFAULT_FARMER = new PlantableFarmer();

    public static void addFarmers() {
        FarmersRegistry.addExtraUtilities();
        FarmersRegistry.addNatura();
        FarmersRegistry.addTiC();
        FarmersRegistry.addStillHungry();
        FarmersRegistry.addIC2();
        FarmersRegistry.addMFR();
        FarmersRegistry.addThaumcraft();
        FarmersRegistry.addFlowers();
        FarmersRegistry.addGrowableOres();
        FarmersRegistry.addImmersiveEngineering();
        FarmersCommune.joinCommune(new StemFarmer(Blocks.reeds, new ItemStack(Items.reeds)));
        FarmersCommune.joinCommune(new StemFarmer(Blocks.cactus, new ItemStack(Blocks.cactus)));
        FarmersCommune.joinCommune(new TreeFarmer(Blocks.sapling, Blocks.log));
        FarmersCommune.joinCommune(new TreeFarmer(Blocks.sapling, Blocks.log2));
        FarmersCommune.joinCommune(new TreeFarmer(true, (Block)Blocks.red_mushroom, Blocks.red_mushroom_block));
        FarmersCommune.joinCommune(new TreeFarmer(true, (Block)Blocks.brown_mushroom, Blocks.brown_mushroom_block));
        FarmersCommune.joinCommune(new MelonFarmer(Blocks.melon_stem, Blocks.melon_block, new ItemStack(Items.melon_seeds)));
        FarmersCommune.joinCommune(new MelonFarmer(Blocks.pumpkin_stem, Blocks.pumpkin, new ItemStack(Items.pumpkin_seeds)));
        FarmersCommune.joinCommune(new NetherWartFarmer());
        FarmersCommune.joinCommune(new CocoaFarmer());
        FarmersCommune.joinCommune(DEFAULT_FARMER);
    }

    public static void addPickable(String mod, String blockName, String itemName) {
        Item seedItem;
        Block cropBlock = GameRegistry.findBlock((String)mod, (String)blockName);
        if (cropBlock != null && (seedItem = GameRegistry.findItem((String)mod, (String)itemName)) != null) {
            FarmersCommune.joinCommune(new PickableFarmer(cropBlock, new ItemStack(seedItem)));
        }
    }

    public static CustomSeedFarmer addSeed(String mod, String blockName, String itemName, Block ... extraFarmland) {
        Item seedItem;
        Block cropBlock = GameRegistry.findBlock((String)mod, (String)blockName);
        if (cropBlock != null && (seedItem = GameRegistry.findItem((String)mod, (String)itemName)) != null) {
            CustomSeedFarmer farmer = new CustomSeedFarmer(cropBlock, new ItemStack(seedItem));
            if (extraFarmland != null) {
                for (Block farmland : extraFarmland) {
                    if (farmland == null) continue;
                    farmer.addTilledBlock(farmland);
                }
            }
            FarmersCommune.joinCommune(farmer);
            return farmer;
        }
        return null;
    }

    private static void addTiC() {
        NaturaBerryFarmer farmer;
        int i;
        Item seedItem;
        String mod = "TConstruct";
        String blockName = "ore.berries.two";
        Block cropBlock = GameRegistry.findBlock((String)mod, (String)blockName);
        if (cropBlock != null && (seedItem = GameRegistry.findItem((String)mod, (String)blockName)) != null) {
            for (i = 0; i < 2; ++i) {
                farmer = new NaturaBerryFarmer(cropBlock, i, 12 + i, new ItemStack(seedItem, 1, 8 + i));
                farmer.setRequiresFarmland(false);
                FarmersCommune.joinCommune(farmer);
            }
        }
        if ((cropBlock = GameRegistry.findBlock((String)mod, (String)(blockName = "ore.berries.one"))) != null && (seedItem = GameRegistry.findItem((String)mod, (String)blockName)) != null) {
            for (i = 0; i < 4; ++i) {
                farmer = new NaturaBerryFarmer(cropBlock, i, 12 + i, new ItemStack(seedItem, 1, 8 + i));
                farmer.setRequiresFarmland(false);
                FarmersCommune.joinCommune(farmer);
            }
        }
    }

    private static void addNatura() {
        Block saplingBlock;
        Item seedItem;
        String mod = "Natura";
        String blockName = "N Crops";
        Block cropBlock = GameRegistry.findBlock((String)mod, (String)blockName);
        if (cropBlock != null) {
            DEFAULT_FARMER.addHarvestExlude(cropBlock);
            seedItem = GameRegistry.findItem((String)mod, (String)"barley.seed");
            if (seedItem != null) {
                FarmersCommune.joinCommune(new CustomSeedFarmer(cropBlock, 3, new ItemStack(seedItem)));
                FarmersCommune.joinCommune(new PickableFarmer(cropBlock, 4, 8, new ItemStack(seedItem, 1, 1)));
            }
        }
        if ((cropBlock = GameRegistry.findBlock((String)mod, (String)(blockName = "BerryBush"))) != null && (seedItem = GameRegistry.findItem((String)mod, (String)blockName)) != null) {
            for (int i = 0; i < 4; ++i) {
                NaturaBerryFarmer farmer = new NaturaBerryFarmer(cropBlock, i, 12 + i, new ItemStack(seedItem, 1, 12 + i));
                farmer.setRequiresFarmland(false);
                FarmersCommune.joinCommune(farmer);
            }
        }
        if ((saplingBlock = GameRegistry.findBlock((String)mod, (String)(blockName = "florasapling"))) != null) {
            FarmersCommune.joinCommune(new TreeFarmer(saplingBlock, GameRegistry.findBlock((String)mod, (String)"tree"), GameRegistry.findBlock((String)mod, (String)"willow"), GameRegistry.findBlock((String)mod, (String)"Dark Tree")));
        }
        if ((saplingBlock = GameRegistry.findBlock((String)mod, (String)(blockName = "Rare Sapling"))) != null) {
            FarmersCommune.joinCommune(new TreeFarmer(saplingBlock, GameRegistry.findBlock((String)mod, (String)"Rare Tree")));
        }
    }

    private static void addThaumcraft() {
        String mod = "Thaumcraft";
        String manaBean = "ItemManaBean";
        String manaPod = "blockManaPod";
        Block block = GameRegistry.findBlock((String)mod, (String)manaPod);
        Item item = GameRegistry.findItem((String)mod, (String)manaBean);
        if (Config.farmManaBeansEnabled && block != null && item != null) {
            FarmersCommune.joinCommune(new ManaBeanFarmer(block, new ItemStack(item)));
        }
    }

    private static void addMFR() {
        String mod = "MineFactoryReloaded";
        String blockName = "rubberwood.sapling";
        Block saplingBlock = GameRegistry.findBlock((String)mod, (String)blockName);
        if (saplingBlock != null) {
            FarmersCommune.joinCommune(new TreeFarmer(saplingBlock, GameRegistry.findBlock((String)mod, (String)"rubberwood.log")));
        }
    }

    private static void addIC2() {
        RubberTreeFarmerIC2 rtf = new RubberTreeFarmerIC2();
        if (rtf.isValid()) {
            FarmersCommune.joinCommune(rtf);
        }
    }

    private static void addStillHungry() {
        String mod = "stillhungry";
        FarmersRegistry.addPickable(mod, "grapeBlock", "StillHungry_grapeSeed");
    }

    private static void addExtraUtilities() {
        String mod = "ExtraUtilities";
        String name = "plant/ender_lilly";
        CustomSeedFarmer farmer = FarmersRegistry.addSeed(mod, name, name, Blocks.end_stone, GameRegistry.findBlock((String)mod, (String)"decorativeBlock1"));
        if (farmer != null) {
            farmer.setIgnoreGroundCanSustainCheck(true);
        }
    }

    private static void addFlowers() {
        FarmersCommune.joinCommune(new FlowerPicker().add(GameRegistry.findBlock((String)"minecraft", (String)"yellow_flower"), GameRegistry.findBlock((String)"minecraft", (String)"red_flower"), GameRegistry.findBlock((String)"BiomesOPlenty", (String)"flowers"), GameRegistry.findBlock((String)"BiomesOPlenty", (String)"flowers2"), GameRegistry.findBlock((String)"Botany", (String)"flower"), GameRegistry.findBlock((String)"Botania", (String)"flower")));
    }

    private static void addGrowableOres() {
        String mod = "B0bGrowsOre";
        if (!Loader.isModLoaded((String)mod)) {
            return;
        }
        Pattern[] growableOres = new Pattern[]{Pattern.compile("(.+)Reed"), Pattern.compile("oreGrowable(.+)")};
        for (Block block : Block.blockRegistry) {
            String name = Block.blockRegistry.getNameForObject((Object)block);
            if (name == null || !name.startsWith(mod)) continue;
            for (Pattern blockPattern : growableOres) {
                if (!blockPattern.matcher(name).find()) continue;
                FarmersCommune.joinCommune(new StemFarmer(block, new ItemStack(block)));
            }
        }
    }

    private static void addImmersiveEngineering() {
        Block hemp = GameRegistry.findBlock((String)"ImmersiveEngineering", (String)"hemp");
        Item hempSeed = GameRegistry.findItem((String)"ImmersiveEngineering", (String)"hemp");
        if (hemp != null && hempSeed != null) {
            FarmersCommune.joinCommune(new StemFarmer(hemp, new ItemStack(hempSeed)));
        }
    }

    private FarmersRegistry() {
    }
}

