/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.enchanter.EnchanterRecipe;
import crazypants.enderio.machine.enchanter.EnchanterRecipeManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnchanter
extends TileEntityEio
implements ISidedInventory {
    private ItemStack[] inv = new ItemStack[3];
    private short facing = (short)ForgeDirection.NORTH.ordinal();

    public void setFacing(short s) {
        this.facing = s;
    }

    public short getFacing() {
        return this.facing;
    }

    protected void writeCustomNBT(NBTTagCompound root) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStackNBT.setByte("Slot", (byte)i);
            this.inv[i].writeToNBT(itemStackNBT);
            itemList.appendTag((NBTBase)itemStackNBT);
        }
        root.setTag("Items", (NBTBase)itemList);
        root.setShort("facing", this.facing);
    }

    protected void readCustomNBT(NBTTagCompound root) {
        NBTTagList itemList = (NBTTagList)root.getTag("Items");
        if (itemList != null) {
            for (int i = 0; i < itemList.tagCount(); ++i) {
                NBTTagCompound itemStack = itemList.getCompoundTagAt(i);
                byte slot = itemStack.getByte("Slot");
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemStack);
            }
        }
        this.facing = root.getShort("facing");
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public int getSizeInventory() {
        return this.inv.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inv.length) {
            return null;
        }
        return this.inv[slot];
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (amount <= 0 || slot < 0 || slot >= this.inv.length || this.inv[slot] == null) {
            return null;
        }
        ItemStack fromStack = this.inv[slot];
        if (fromStack == null) {
            return null;
        }
        if (fromStack.stackSize <= amount) {
            this.inv[slot] = null;
            return fromStack;
        }
        ItemStack result = new ItemStack(fromStack.getItem(), amount, fromStack.getItemDamage());
        if (fromStack.stackTagCompound != null) {
            result.stackTagCompound = (NBTTagCompound)fromStack.stackTagCompound.copy();
        }
        fromStack.stackSize -= amount;
        return result;
    }

    public ItemStack getStackInSlotOnClosing(int p_70304_1_) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack contents) {
        this.inv[slot] = contents == null ? contents : contents.copy();
        if (contents != null && contents.stackSize > this.getInventoryStackLimit()) {
            contents.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInventoryName() {
        return ModObject.blockEnchanter.unlocalisedName;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (slot == 0) {
            return Items.writable_book == stack.getItem();
        }
        if (slot == 1) {
            return EnchanterRecipeManager.getInstance().getEnchantmentRecipeForInput(stack) != null;
        }
        return false;
    }

    public EnchanterRecipe getCurrentEnchantmentRecipe() {
        if (this.inv[0] == null) {
            return null;
        }
        if (this.inv[1] == null) {
            return null;
        }
        EnchanterRecipe ench = EnchanterRecipeManager.getInstance().getEnchantmentRecipeForInput(this.inv[1]);
        if (ench == null) {
            return null;
        }
        int level = ench.getLevelForStackSize(this.inv[1].stackSize);
        if (level <= 0) {
            return null;
        }
        return ench;
    }

    public EnchantmentData getCurrentEnchantmentData() {
        EnchanterRecipe rec = this.getCurrentEnchantmentRecipe();
        if (rec == null || this.inv[1] == null) {
            return null;
        }
        int level = rec.getLevelForStackSize(this.inv[1].stackSize);
        if (level <= 0) {
            return null;
        }
        return new EnchantmentData(rec.getEnchantment(), level);
    }

    public int getCurrentEnchantmentCost() {
        return this.getEnchantmentCost(this.getCurrentEnchantmentRecipe());
    }

    private int getEnchantmentCost(EnchanterRecipe currentEnchantment) {
        ItemStack item = this.inv[1];
        if (item == null) {
            return 0;
        }
        if (currentEnchantment == null) {
            return 0;
        }
        Enchantment enchantment = currentEnchantment.getEnchantment();
        int level = currentEnchantment.getLevelForStackSize(item.stackSize);
        return TileEnchanter.getEnchantmentCost(currentEnchantment, level);
    }

    public static int getEnchantmentCost(EnchanterRecipe recipe, int level) {
        if (level > recipe.getEnchantment().getMaxLevel()) {
            level = recipe.getEnchantment().getMaxLevel();
        }
        int costPerLevel = recipe.getCostPerLevel();
        int res = Config.enchanterBaseLevelCost;
        for (int i = 0; i < level; ++i) {
            res += costPerLevel * level;
        }
        return res;
    }

    public void setOutput(ItemStack output) {
        this.inv[this.inv.length - 1] = output;
        this.markDirty();
    }

    public int[] getAccessibleSlotsFromSide(int p_94128_1_) {
        return new int[0];
    }

    public boolean canInsertItem(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean canExtractItem(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }
}

