/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.enchanter.ContainerEnchanter;
import crazypants.enderio.machine.enchanter.TileEnchanter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import org.lwjgl.opengl.GL11;

public class GuiEnchanter
extends GuiContainerBase {
    private TileEnchanter te;
    private ContainerEnchanter container;
    private IconButton recipeButton;

    public GuiEnchanter(EntityPlayer player, InventoryPlayer inventory, TileEnchanter te) {
        super((Container)new ContainerEnchanter(player, inventory, te));
        this.container = (ContainerEnchanter)this.inventorySlots;
        this.te = te;
        this.recipeButton = new IconButton((IGuiScreen)this, 100, 154, 8, (IWidgetIcon)IconEIO.RECIPE);
        this.recipeButton.visible = false;
        this.recipeButton.setIconMargin(1, 1);
    }

    public void initGui() {
        super.initGui();
        this.recipeButton.onGuiInit();
        this.recipeButton.visible = EnderIO.proxy.isNeiInstalled();
    }

    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        int curCost;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)"enderio:textures/gui/enchanter.png");
        int sx = (this.width - this.xSize) / 2;
        int sy = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        if (EnderIO.proxy.isNeiInstalled()) {
            IconEIO.map.render((IWidgetIcon)IconEIO.RECIPE, (double)(sx + 155), (double)(sy + 8), 16.0, 16.0, 0.0, true);
        }
        if ((curCost = this.te.getCurrentEnchantmentCost()) > 0) {
            int col;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.container.playerHasEnoughLevels((EntityPlayer)Minecraft.getMinecraft().thePlayer)) {
                col = 8453920;
            } else {
                col = 0xFF6060;
                RenderUtil.bindTexture((String)"enderio:textures/gui/enchanter.png");
                this.drawTexturedModalRect(sx + 99, sy + 33, 176, 0, 28, 21);
            }
            String s = I18n.format((String)"container.repair.cost", (Object[])new Object[]{curCost});
            this.drawCenteredString(Minecraft.getMinecraft().fontRenderer, s, sx + this.xSize / 2, sy + 57, col);
        }
    }
}

