/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import com.enderio.core.common.ContainerEnder;
import crazypants.enderio.machine.enchanter.EnchanterRecipe;
import crazypants.enderio.machine.enchanter.TileEnchanter;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ContainerEnchanter
extends ContainerEnder<TileEnchanter> {
    public ContainerEnchanter(EntityPlayer player, InventoryPlayer playerInv, TileEnchanter te) {
        super(playerInv, (IInventory)te);
    }

    protected void addSlots(InventoryPlayer playerInv) {
        final TileEnchanter te = (TileEnchanter)this.getInv();
        this.addSlotToContainer(new Slot((IInventory)te, 0, 27, 35){

            public int getSlotStackLimit() {
                return 1;
            }

            public boolean isItemValid(ItemStack itemStack) {
                return te.isItemValidForSlot(0, itemStack);
            }

            public void onSlotChanged() {
                ContainerEnchanter.this.updateOutput();
            }
        });
        this.addSlotToContainer(new Slot((IInventory)te, 1, 76, 35){

            public boolean isItemValid(ItemStack itemStack) {
                return te.isItemValidForSlot(1, itemStack);
            }

            public void onSlotChanged() {
                ContainerEnchanter.this.updateOutput();
            }
        });
        this.addSlotToContainer(new Slot((IInventory)te, 2, 134, 35){

            public int getSlotStackLimit() {
                return 1;
            }

            public boolean isItemValid(ItemStack itemStack) {
                return false;
            }

            public void onPickupFromSlot(EntityPlayer player, ItemStack stack) {
                if (!player.capabilities.isCreativeMode) {
                    player.addExperienceLevel(-te.getCurrentEnchantmentCost());
                }
                EnchantmentData enchData = te.getCurrentEnchantmentData();
                EnchanterRecipe recipe = te.getCurrentEnchantmentRecipe();
                ItemStack curStack = te.getStackInSlot(1);
                if (recipe == null || enchData == null || curStack == null || enchData.enchantmentLevel >= curStack.stackSize) {
                    te.setInventorySlotContents(1, null);
                } else {
                    curStack = curStack.copy();
                    curStack.stackSize -= recipe.getItemsPerLevel() * enchData.enchantmentLevel;
                    if (curStack.stackSize > 0) {
                        te.setInventorySlotContents(1, curStack);
                    } else {
                        te.setInventorySlotContents(1, null);
                    }
                    te.markDirty();
                }
                te.setInventorySlotContents(0, null);
                if (!te.getWorldObj().isRemote) {
                    te.getWorldObj().playAuxSFX(1021, te.xCoord, te.yCoord, te.zCoord, 0);
                }
            }

            public boolean canTakeStack(EntityPlayer player) {
                return ContainerEnchanter.this.playerHasEnoughLevels(player);
            }
        });
    }

    public boolean playerHasEnoughLevels(EntityPlayer player) {
        if (player.capabilities.isCreativeMode) {
            return true;
        }
        return player.experienceLevel >= ((TileEnchanter)this.getInv()).getCurrentEnchantmentCost();
    }

    private void updateOutput() {
        ItemStack output = null;
        EnchantmentData enchantment = ((TileEnchanter)this.getInv()).getCurrentEnchantmentData();
        if (enchantment != null) {
            output = new ItemStack((Item)Items.enchanted_book);
            Items.enchanted_book.addEnchantment(output, enchantment);
        }
        ((TileEnchanter)this.getInv()).setOutput(output);
    }

    public ItemStack transferStackInSlot(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack copyStack = null;
        Slot slot = (Slot)this.inventorySlots.get(par2);
        if (slot != null && slot.getHasStack()) {
            ItemStack origStack = slot.getStack();
            copyStack = origStack.copy();
            if (par2 <= 2 ? !this.mergeItemStack(origStack, 2, this.inventorySlots.size(), true) : !(((TileEnchanter)this.getInv()).isItemValidForSlot(0, origStack) && this.mergeItemStack(origStack, 0, 1, false) || ((TileEnchanter)this.getInv()).isItemValidForSlot(1, origStack) && this.mergeItemStack(origStack, 1, 2, false))) {
                return null;
            }
            if (origStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
            slot.onPickupFromSlot(par1EntityPlayer, origStack);
        }
        return copyStack;
    }
}

