/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crusher;

import crazypants.enderio.Log;
import crazypants.enderio.machine.crusher.GrindingBall;
import crazypants.enderio.machine.recipe.CustomTagHandler;
import crazypants.enderio.machine.recipe.RecipeConfigParser;
import crazypants.enderio.machine.recipe.RecipeInput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GrindingBallTagHandler
implements CustomTagHandler {
    private static final String ELEMENT_ROOT = "grindingBalls";
    private static final String BALL_ROOT = "grindingBall";
    private static final String EXCLUDES_ROOT = "excludes";
    private static final String AT_ID = "id";
    private static final String AT_REMOVE = "remove";
    private static final String AT_GM = "grindingMultiplier";
    private static final String AT_PM = "powerMultiplier";
    private static final String AT_CM = "chanceMultiplier";
    private static final String AT_DMJ = "durationRF";
    Map<String, GrindingBall> balls = new HashMap<String, GrindingBall>();
    List<RecipeInput> excludes = new ArrayList<RecipeInput>();
    boolean processStack = false;
    boolean processExclude = false;
    private String id;
    private float gm;
    private float pm;
    private float cm;
    private int drf;

    @Override
    public boolean startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        RecipeInput ri;
        if (ELEMENT_ROOT.equals(localName)) {
            return true;
        }
        if (BALL_ROOT.equals(localName)) {
            this.id = RecipeConfigParser.getStringValue(AT_ID, attributes, null);
            if (this.id == null) {
                Log.warn("GrindingBallTagHandler: grinding ball specified without the 'id' attribute. It will be ignored.");
                this.processStack = false;
                return true;
            }
            boolean remove = RecipeConfigParser.getBooleanValue(AT_REMOVE, attributes, false);
            if (remove) {
                GrindingBall res = this.balls.remove(this.id);
                if (res == null) {
                    Log.warn("User config requested removal of grinding ball with id: " + this.id + " but it was not found.");
                } else {
                    Log.info("Removed grinding ball with id=" + this.id + " due to user config.");
                }
                this.processStack = false;
                return true;
            }
            this.gm = RecipeConfigParser.getFloatValue(AT_GM, attributes, 1.0f);
            this.cm = RecipeConfigParser.getFloatValue(AT_CM, attributes, 1.0f);
            this.pm = RecipeConfigParser.getFloatValue(AT_PM, attributes, 1.0f);
            this.drf = RecipeConfigParser.getIntValue(AT_DMJ, attributes, 24000);
            this.processStack = true;
            return true;
        }
        if (EXCLUDES_ROOT.equals(localName)) {
            this.processExclude = true;
            return true;
        }
        if (this.processStack && "itemStack".equals(localName) && (ri = RecipeConfigParser.getItemStack(attributes)) != null) {
            GrindingBall gb = new GrindingBall(ri, this.gm, this.cm, this.pm, this.drf);
            this.balls.put(this.id, gb);
        }
        if (this.processExclude && "itemStack".equals(localName) && (ri = RecipeConfigParser.getItemStack(attributes)) != null) {
            boolean remove = RecipeConfigParser.getBooleanValue(AT_REMOVE, attributes, false);
            if (remove) {
                this.excludes.remove(ri);
                Log.info("Removed grinding ball exclude for " + ri.getInput().getDisplayName() + " due to user config.");
            } else {
                this.excludes.add(ri);
            }
        }
        return false;
    }

    @Override
    public boolean endElement(String uri, String localName, String qName) throws SAXException {
        if (ELEMENT_ROOT.equals(localName) || BALL_ROOT.equals(localName) || EXCLUDES_ROOT.equals(localName)) {
            this.processStack = false;
            this.processExclude = false;
            return true;
        }
        return false;
    }

    @Override
    public void configProcessed() {
    }
}

