/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crafter;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DummyCraftingGrid
implements IInventory {
    ItemStack[] inv = new ItemStack[10];

    public boolean hasValidRecipe() {
        return this.getOutput() != null;
    }

    public ItemStack getOutput() {
        return this.inv[9];
    }

    public int getSizeInventory() {
        return this.inv.length;
    }

    public ItemStack getStackInSlot(int var1) {
        if (var1 < 0 || var1 >= this.inv.length) {
            return null;
        }
        return this.inv[var1];
    }

    public ItemStack decrStackSize(int fromSlot, int amount) {
        ItemStack item = this.inv[fromSlot];
        this.inv[fromSlot] = null;
        if (item == null) {
            return null;
        }
        item.stackSize = 0;
        return item;
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        if (itemstack != null) {
            this.inv[i] = itemstack.copy();
            if (i < 9) {
                this.inv[i].stackSize = 0;
            }
        } else {
            this.inv[i] = null;
        }
    }

    public String getInventoryName() {
        return "CraftingGrid";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 0;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int var1, ItemStack var2) {
        return var1 < 9;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        NBTTagList itemList = (NBTTagList)nbtRoot.getTag("Items");
        if (itemList == null) {
            for (int i = 0; i < this.inv.length; ++i) {
                this.inv[i] = null;
            }
            return;
        }
        for (int i = 0; i < itemList.tagCount(); ++i) {
            NBTTagCompound itemStack = itemList.getCompoundTagAt(i);
            byte slot = itemStack.getByte("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemStack);
        }
    }

    public void writeToNBT(NBTTagCompound nbtRoot) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStackNBT.setByte("Slot", (byte)i);
            this.inv[i].writeToNBT(itemStackNBT);
            itemList.appendTag((NBTBase)itemStackNBT);
        }
        nbtRoot.setTag("Items", (NBTBase)itemList);
    }
}

