/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.render;

import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.render.IInfoRenderer;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class IoDisplay
implements IInfoRenderer {
    @Override
    public void render(TileCapBank cb, ForgeDirection dir, double x, double y, double z, float partialTick) {
        float offset;
        String text1;
        if (dir.offsetY != 0) {
            return;
        }
        CapBankClientNetwork nw = (CapBankClientNetwork)cb.getNetwork();
        if (nw == null) {
            return;
        }
        CapBankClientNetwork.IOInfo info = nw.getIODisplayInfo(cb.xCoord, cb.yCoord, cb.zCoord, dir);
        if (info.isInside()) {
            return;
        }
        boolean selfIlum = true;
        int brightness = 0;
        if (!selfIlum) {
            brightness = cb.getWorldObj().getLightBrightnessForSkyBlocks(cb.xCoord + dir.offsetX, cb.yCoord + dir.offsetY, cb.zCoord + dir.offsetZ, 0);
            int l1 = brightness % 65536;
            int l2 = brightness / 65536;
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)l1, (float)l2);
        } else {
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
        }
        boolean drawBackground = true;
        if (drawBackground) {
            RenderUtil.bindBlockTexture();
            Tessellator tes = Tessellator.instance;
            tes.startDrawingQuads();
            if (!selfIlum) {
                tes.setBrightness(brightness);
            }
            tes.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            float scale = 0.85f;
            float offset2 = (1.0f - scale) / 2.0f;
            IIcon icon = EnderIO.blockCapBank.getInfoPanelIcon();
            float minU = icon.getMinU();
            float maxU = icon.getMaxU();
            float minV = icon.getMinV();
            float maxV = icon.getMaxV();
            switch (dir) {
                case NORTH: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float x0 = offset2;
                    float x1 = (float)info.width - offset2;
                    float z0 = 0.0f;
                    tes.setNormal(0.0f, 0.0f, -1.0f);
                    tes.addVertexWithUV((double)x1, (double)y0, (double)z0, (double)minU, (double)minV);
                    tes.addVertexWithUV((double)x0, (double)y0, (double)z0, (double)maxU, (double)minV);
                    tes.addVertexWithUV((double)x0, (double)y1, (double)z0, (double)maxU, (double)maxV);
                    tes.addVertexWithUV((double)x1, (double)y1, (double)z0, (double)minU, (double)maxV);
                    break;
                }
                case SOUTH: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float x0 = offset2 - (float)(info.width - 1);
                    float x1 = 1.0f - offset2;
                    float z1 = 1.0f;
                    tes.setNormal(0.0f, 0.0f, 1.0f);
                    tes.addVertexWithUV((double)x0, (double)y0, (double)z1, (double)maxU, (double)minV);
                    tes.addVertexWithUV((double)x1, (double)y0, (double)z1, (double)minU, (double)minV);
                    tes.addVertexWithUV((double)x1, (double)y1, (double)z1, (double)minU, (double)maxV);
                    tes.addVertexWithUV((double)x0, (double)y1, (double)z1, (double)maxU, (double)maxV);
                    break;
                }
                case EAST: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float z0 = offset2;
                    float z1 = (float)info.width - offset2;
                    float x1 = 1.0f;
                    tes.setNormal(1.0f, 0.0f, 0.0f);
                    tes.addVertexWithUV((double)x1, (double)y1, (double)z0, (double)maxU, (double)maxV);
                    tes.addVertexWithUV((double)x1, (double)y1, (double)z1, (double)minU, (double)maxV);
                    tes.addVertexWithUV((double)x1, (double)y0, (double)z1, (double)minU, (double)minV);
                    tes.addVertexWithUV((double)x1, (double)y0, (double)z0, (double)maxU, (double)minV);
                    break;
                }
                case WEST: {
                    float y0 = offset2 - (float)(info.height - 1);
                    float y1 = 1.0f - offset2;
                    float z0 = offset2 - (float)(info.width - 1);
                    float z1 = 1.0f - offset2;
                    float x0 = 0.0f;
                    tes.setNormal(-1.0f, 0.0f, 0.0f);
                    tes.addVertexWithUV((double)x0, (double)y0, (double)z0, (double)maxU, (double)minV);
                    tes.addVertexWithUV((double)x0, (double)y0, (double)z1, (double)minU, (double)minV);
                    tes.addVertexWithUV((double)x0, (double)y1, (double)z1, (double)minU, (double)maxV);
                    tes.addVertexWithUV((double)x0, (double)y1, (double)z0, (double)maxU, (double)maxV);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            tes.draw();
        }
        nw.requestPowerUpdate(cb, 20);
        HeadingText heading1 = HeadingText.STABLE;
        HeadingText heading2 = null;
        String text2 = "";
        FontRenderer fr = Minecraft.getMinecraft().fontRenderer;
        float size = 0.15f * (float)Math.min(info.width, info.height);
        float scale = size / (float)fr.FONT_HEIGHT;
        if (info.height * 3 >= info.width * 4) {
            heading1 = HeadingText.INPUT;
            heading2 = HeadingText.OUTPUT;
            text1 = this.getChangeText(nw.getAverageInputPerTick(), fr);
            text2 = this.getChangeText(nw.getAverageOutputPerTick(), fr);
            offset = -size * 2.5f;
        } else {
            int change = Math.round(nw.getAverageChangePerTick());
            if (change > 0) {
                heading1 = HeadingText.GAIN;
            } else if (change < 0) {
                heading1 = HeadingText.LOSS;
            }
            text1 = this.getChangeText(change, fr);
            offset = -size;
        }
        ForgeDirection right = dir.getRotation(ForgeDirection.UP);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)dir.offsetX * 1.02f / 2.0f + 0.5f + (float)(right.offsetX * (info.width - 1)) * 0.5f), (float)(1.0f + size * 0.5f - (float)info.height * 0.5f), (float)((float)dir.offsetZ * 1.02f / 2.0f + 0.5f + (float)(right.offsetZ * (info.width - 1)) * 0.5f));
        GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (dir == ForgeDirection.NORTH) {
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (dir == ForgeDirection.EAST) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (dir == ForgeDirection.WEST) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        offset = this.drawText(heading1, text1, offset, scale, size, fr);
        if (heading2 != null) {
            this.drawText(heading2, text2, offset, scale, size, fr);
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private float drawText(HeadingText heading, String text, float offset, float scale, float size, FontRenderer fr) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)offset, (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        fr.drawString(heading.text, -fr.getStringWidth(heading.text) / 2, 0, 0);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(offset += size * 1.5f), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        fr.drawString(text, -fr.getStringWidth(text) / 2, 0, heading.color);
        GL11.glPopMatrix();
        return offset += size * 1.5f;
    }

    protected String getChangeText(float average, FontRenderer fr) {
        int change = Math.round(Math.abs(average));
        String txt = PowerDisplayUtil.INT_NF.format(change);
        int width = fr.getStringWidth(txt);
        if (width > 38 && change > 1000) {
            txt = PowerDisplayUtil.INT_NF.format(change /= 1000) + "K";
        }
        return txt;
    }

    static enum HeadingText {
        STABLE(ColorUtil.getRGB((int)0, (int)0, (int)0)),
        GAIN(ColorUtil.getRGB((float)0.0f, (float)0.25f, (float)0.0f)),
        LOSS(ColorUtil.getRGB((float)0.25f, (float)0.0f, (float)0.0f)),
        INPUT(ColorUtil.getRGB((float)0.0f, (float)0.25f, (float)0.0f)),
        OUTPUT(ColorUtil.getRGB((float)0.25f, (float)0.0f, (float)0.0f));

        final String text = EnderIO.lang.localize("capbank.iodisplay.".concat(this.name().toLowerCase(Locale.US)));
        final int color;

        private HeadingText(int color) {
            this.color = color;
        }
    }
}

