/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import com.enderio.core.common.ContainerEnder;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.InventoryImpl;
import crazypants.util.BaublesUtil;
import crazypants.util.ShadowInventory;
import java.awt.Point;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ContainerCapBank
extends ContainerEnder<TileCapBank> {
    private InventoryImpl inv;
    private IInventory baubles;

    public ContainerCapBank(InventoryPlayer playerInv, TileCapBank cb) {
        super(playerInv, (IInventory)cb);
    }

    public boolean hasBaublesSlots() {
        return this.baubles != null;
    }

    protected void addSlots(final InventoryPlayer playerInv) {
        int i;
        this.inv = ((TileCapBank)this.getInv()).getNetwork() != null && ((TileCapBank)this.getInv()).getNetwork().getInventory() != null ? ((TileCapBank)this.getInv()).getNetwork().getInventory() : new InventoryImpl();
        this.baubles = BaublesUtil.instance().getBaubles(playerInv.player);
        if (this.baubles != null && BaublesUtil.WhoAmI.whoAmI(playerInv.player.worldObj) == BaublesUtil.WhoAmI.SPCLIENT) {
            this.baubles = new ShadowInventory(this.baubles);
        }
        int armorOffset = 21;
        for (i = 0; i < 4; ++i) {
            this.addSlotToContainer(new SlotImpl(this.inv, i, 59 + armorOffset + i * 20, 59));
        }
        for (i = 0; i < 4; ++i) {
            final int k = i;
            this.addSlotToContainer(new Slot((IInventory)playerInv, playerInv.getSizeInventory() - 1 - i, -15 + armorOffset, 12 + i * 18){

                public int getSlotStackLimit() {
                    return 1;
                }

                public boolean isItemValid(ItemStack par1ItemStack) {
                    if (par1ItemStack == null) {
                        return false;
                    }
                    return par1ItemStack.getItem().isValidArmor(par1ItemStack, k, (Entity)playerInv.player);
                }

                @SideOnly(value=Side.CLIENT)
                public IIcon getBackgroundIconIndex() {
                    return ItemArmor.func_94602_b((int)k);
                }
            });
        }
        if (this.hasBaublesSlots()) {
            for (i = 0; i < this.baubles.getSizeInventory(); ++i) {
                this.addSlotToContainer(new Slot(this.baubles, i, -15 + armorOffset, 84 + i * 18){

                    public boolean isItemValid(ItemStack par1ItemStack) {
                        return this.inventory.isItemValidForSlot(this.getSlotIndex(), par1ItemStack);
                    }
                });
            }
        }
    }

    public void updateInventory() {
        if (((TileCapBank)this.getInv()).getNetwork() != null && ((TileCapBank)this.getInv()).getNetwork().getInventory() != null) {
            this.inv.setCapBank(((TileCapBank)this.getInv()).getNetwork().getInventory().getCapBank());
        }
    }

    public Point getPlayerInventoryOffset() {
        Point p = super.getPlayerInventoryOffset();
        p.translate(21, 0);
        return p;
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        int startPlayerSlot = 4;
        int endPlayerSlot = startPlayerSlot + 26;
        int startHotBarSlot = endPlayerSlot + 1;
        int endHotBarSlot = startHotBarSlot + 9;
        int startBaublesSlot = endHotBarSlot + 1;
        int endBaublesSlot = this.baubles == null ? 0 : startBaublesSlot + this.baubles.getSizeInventory();
        ItemStack copystack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot != null && slot.getHasStack()) {
            ItemStack origStack = slot.getStack();
            copystack = origStack.copy();
            if (slotIndex < 4 ? !this.mergeItemStackIntoArmor(entityPlayer, origStack, slotIndex) && !this.mergeItemStack(origStack, startPlayerSlot, endHotBarSlot, false) : slotIndex >= startPlayerSlot && (!this.inv.isItemValidForSlot(0, origStack) || !this.mergeItemStack(origStack, 0, 4, false)) && (slotIndex <= endPlayerSlot ? !this.mergeItemStack(origStack, startHotBarSlot, endHotBarSlot, false) : (slotIndex >= startHotBarSlot && slotIndex <= endHotBarSlot ? !this.mergeItemStack(origStack, startPlayerSlot, endPlayerSlot, false) : slotIndex >= startBaublesSlot && slotIndex <= endBaublesSlot && !this.mergeItemStack(origStack, startHotBarSlot, endHotBarSlot, false) && !this.mergeItemStack(origStack, startPlayerSlot, endPlayerSlot, false)))) {
                return null;
            }
            if (origStack.stackSize == 0) {
                slot.putStack((ItemStack)null);
            } else {
                slot.onSlotChanged();
            }
            slot.onSlotChanged();
            if (origStack.stackSize == copystack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(entityPlayer, origStack);
        }
        return copystack;
    }

    private boolean mergeItemStackIntoArmor(EntityPlayer entityPlayer, ItemStack origStack, int slotIndex) {
        if (origStack == null || !(origStack.getItem() instanceof ItemArmor)) {
            return false;
        }
        ItemArmor armor = (ItemArmor)origStack.getItem();
        ItemStack[] ai = entityPlayer.inventory.armorInventory;
        int index = 3 - armor.armorType;
        if (ai[index] == null) {
            ai[index] = origStack.copy();
            origStack.stackSize = 0;
            return true;
        }
        return false;
    }

    private static class SlotImpl
    extends Slot {
        public SlotImpl(IInventory inv, int idx, int x, int y) {
            super(inv, idx, x, y);
        }

        public boolean isItemValid(ItemStack itemStack) {
            return this.inventory.isItemValidForSlot(this.getSlotIndex(), itemStack);
        }
    }
}

