/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import cofh.api.energy.IEnergyContainerItem;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.power.PowerHandlerUtil;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class BlockItemCapBank
extends ItemBlock
implements IEnergyContainerItem {
    public static ItemStack createItemStackWithPower(int meta, int storedEnergy) {
        ItemStack res = new ItemStack((Block)EnderIO.blockCapBank, 1, meta);
        PowerHandlerUtil.setStoredEnergyForItem(res, storedEnergy);
        CapBankType type = CapBankType.getTypeFromMeta(meta);
        type.writeTypeToNBT(res.stackTagCompound);
        return res;
    }

    public BlockItemCapBank() {
        super((Block)EnderIO.blockCapBank);
        this.setHasSubtypes(true);
    }

    public BlockItemCapBank(Block block) {
        super(block);
        this.setHasSubtypes(true);
        this.setCreativeTab(EnderIOTab.tabEnderIO);
    }

    public int getMetadata(int par1) {
        return par1;
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return CapBankType.getTypeFromMeta(par1ItemStack.getItemDamage()).getUnlocalizedName();
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return !CapBankType.getTypeFromMeta(itemStack.getItemDamage()).isCreative();
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        int maxStored = CapBankType.getTypeFromMeta(itemStack.getItemDamage()).getMaxEnergyStored();
        double stored = maxStored - this.getEnergyStored(itemStack) + 1;
        double max = maxStored + 1;
        return stored / max;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.stackSize > 1) {
            return 0;
        }
        CapBankType type = CapBankType.getTypeFromMeta(container.getItemDamage());
        int energy = this.getEnergyStored(container);
        int maxInput = type.getMaxIO();
        int energyReceived = Math.min(type.getMaxEnergyStored() - energy, Math.min(maxReceive, maxInput));
        if (!simulate && !type.isCreative()) {
            PowerHandlerUtil.setStoredEnergyForItem(container, energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.stackSize > 1) {
            return 0;
        }
        CapBankType type = CapBankType.getTypeFromMeta(container.getItemDamage());
        int energy = this.getEnergyStored(container);
        int maxOutput = type.getMaxIO();
        int energyExtracted = Math.min(energy, Math.min(maxExtract, maxOutput));
        if (!simulate && !type.isCreative()) {
            PowerHandlerUtil.setStoredEnergyForItem(container, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return PowerHandlerUtil.getStoredEnergyForItem(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return CapBankType.getTypeFromMeta(container.getItemDamage()).getMaxEnergyStored();
    }
}

