/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.alloy;

import com.enderio.core.client.gui.button.IIconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector4f;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.alloy.ContainerAlloySmelter;
import crazypants.enderio.machine.alloy.PacketClientState;
import crazypants.enderio.machine.alloy.TileAlloySmelter;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.network.PacketHandler;
import java.awt.Rectangle;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class GuiAlloySmelter
extends GuiPoweredMachineBase<TileAlloySmelter> {
    private final IIconButton vanillaFurnaceButton = new IIconButton(this.getFontRenderer(), 76, 0, 0, null, RenderUtil.BLOCK_TEX);
    private final GuiToolTip vanillaFurnaceTooltip;
    protected static final int SMELT_MODE_BUTTON_ID = 76;

    public GuiAlloySmelter(InventoryPlayer par1InventoryPlayer, TileAlloySmelter furnaceInventory) {
        super(furnaceInventory, (Container)new ContainerAlloySmelter(par1InventoryPlayer, furnaceInventory));
        this.vanillaFurnaceButton.setSize(16, 16);
        this.vanillaFurnaceTooltip = new GuiToolTip(new Rectangle(this.xSize - 5 - 16, 62, 16, 16), (String[])null);
        this.addProgressTooltip(55, 35, 14, 14);
        this.addProgressTooltip(103, 35, 14, 14);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.vanillaFurnaceButton.xPosition = this.guiLeft + this.vanillaFurnaceTooltip.getBounds().x;
        this.vanillaFurnaceButton.yPosition = this.guiTop + this.vanillaFurnaceTooltip.getBounds().y;
        this.buttonList.add(this.vanillaFurnaceButton);
        this.addToolTip(this.vanillaFurnaceTooltip);
        this.updateVanillaFurnaceButton();
    }

    @Override
    protected void renderSlotHighlight(int slot, Vector4f col) {
        if (((TileAlloySmelter)this.getTileEntity()).getSlotDefinition().isOutputSlot(slot)) {
            this.renderSlotHighlight(col, 75, 54, 24, 24);
        } else {
            super.renderSlotHighlight(slot, col);
        }
    }

    protected void actionPerformed(GuiButton par1GuiButton) {
        if (par1GuiButton.id == 76) {
            ((TileAlloySmelter)this.getTileEntity()).setMode(((TileAlloySmelter)this.getTileEntity()).getMode().next());
            this.updateVanillaFurnaceButton();
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketClientState((TileAlloySmelter)this.getTileEntity()));
        } else {
            super.actionPerformed(par1GuiButton);
        }
    }

    private void updateVanillaFurnaceButton() {
        IIcon icon = EnderIO.blockAlloySmelter.vanillaSmeltingOn;
        String unlocText = "gui.alloy.mode.all";
        if (((TileAlloySmelter)this.getTileEntity()).getMode() == TileAlloySmelter.Mode.ALLOY) {
            icon = EnderIO.blockAlloySmelter.vanillaSmeltingOff;
            unlocText = "gui.alloy.mode.alloy";
        } else if (((TileAlloySmelter)this.getTileEntity()).getMode() == TileAlloySmelter.Mode.FURNACE) {
            icon = EnderIO.blockAlloySmelter.vanillaSmeltingOnly;
            unlocText = "gui.alloy.mode.furnace";
        }
        this.vanillaFurnaceButton.setIcon(icon);
        this.vanillaFurnaceTooltip.setToolTipText(new String[]{EnderIO.lang.localize("gui.alloy.mode.heading"), EnderIO.lang.localize(unlocText)});
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)"enderio:textures/gui/alloySmelter.png");
        int sx = this.guiLeft;
        int sy = this.guiTop;
        this.drawTexturedModalRect(sx, sy, 0, 0, this.xSize, this.ySize);
        if (this.shouldRenderProgress()) {
            int scaled = this.getProgressScaled(14) + 1;
            this.drawTexturedModalRect(sx + 55, sy + 49 - scaled, 176, 14 - scaled, 14, scaled);
            this.drawTexturedModalRect(sx + 103, sy + 49 - scaled, 176, 14 - scaled, 14, scaled);
        }
        super.drawGuiContainerBackgroundLayer(par1, par2, par3);
    }
}

