/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.alloy;

import com.enderio.core.common.util.Util;
import crazypants.enderio.machine.alloy.TileAlloySmelter;
import crazypants.enderio.machine.gui.AbstractMachineContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;

public class ContainerAlloySmelter
extends AbstractMachineContainer<TileAlloySmelter> {
    private final EntityPlayer thePlayer;

    public ContainerAlloySmelter(InventoryPlayer playerInv, TileAlloySmelter te) {
        super(playerInv, te);
        this.thePlayer = playerInv.player;
    }

    @Override
    protected void addMachineSlots(InventoryPlayer playerInv) {
        this.addSlotToContainer(new Slot(this.getInv(), 0, 54, 17){

            public boolean isItemValid(ItemStack itemStack) {
                return ((TileAlloySmelter)ContainerAlloySmelter.this.getInv()).isItemValidForSlot(0, itemStack);
            }
        });
        this.addSlotToContainer(new Slot(this.getInv(), 1, 79, 7){

            public boolean isItemValid(ItemStack itemStack) {
                return ((TileAlloySmelter)ContainerAlloySmelter.this.getInv()).isItemValidForSlot(1, itemStack);
            }
        });
        this.addSlotToContainer(new Slot(this.getInv(), 2, 103, 17){

            public boolean isItemValid(ItemStack itemStack) {
                return ((TileAlloySmelter)ContainerAlloySmelter.this.getInv()).isItemValidForSlot(2, itemStack);
            }
        });
        this.addSlotToContainer(new SlotSmelter(this.getInv(), 3, 79, 57));
    }

    private class SlotSmelter
    extends Slot {
        int numResults;

        public SlotSmelter(IInventory par1iInventory, int par2, int par3, int par4) {
            super(par1iInventory, par2, par3, par4);
            this.numResults = 0;
        }

        public ItemStack decrStackSize(int par1) {
            if (this.getHasStack()) {
                this.numResults += Math.min(par1, this.getStack().stackSize);
            }
            return super.decrStackSize(par1);
        }

        public boolean isItemValid(ItemStack par1ItemStack) {
            return false;
        }

        public void onPickupFromSlot(EntityPlayer par1EntityPlayer, ItemStack output) {
            this.onCrafting(output);
            super.onPickupFromSlot(par1EntityPlayer, output);
        }

        protected void onCrafting(ItemStack par1ItemStack, int par2) {
            this.numResults += par2;
            this.onCrafting(par1ItemStack);
        }

        protected void onCrafting(ItemStack output) {
            output.onCrafting(((ContainerAlloySmelter)ContainerAlloySmelter.this).thePlayer.worldObj, ContainerAlloySmelter.this.thePlayer, this.numResults);
            if (!((ContainerAlloySmelter)ContainerAlloySmelter.this).thePlayer.worldObj.isRemote) {
                ItemStack outputSized = output.copy();
                outputSized.stackSize = this.numResults;
                float experience = ((TileAlloySmelter)ContainerAlloySmelter.this.getInv()).getExperienceForOutput(outputSized);
                Util.giveExperience((EntityPlayer)ContainerAlloySmelter.this.thePlayer, (float)experience);
            }
            this.numResults = 0;
            if (output.getItem() == Items.iron_ingot) {
                ContainerAlloySmelter.this.thePlayer.addStat((StatBase)AchievementList.acquireIron, 1);
            }
            if (output.getItem() == Items.cooked_fished) {
                ContainerAlloySmelter.this.thePlayer.addStat((StatBase)AchievementList.cookFish, 1);
            }
        }
    }
}

