/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.alloy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.alloy.ContainerAlloySmelter;
import crazypants.enderio.machine.alloy.GuiAlloySmelter;
import crazypants.enderio.machine.alloy.PacketClientState;
import crazypants.enderio.machine.alloy.TileAlloySmelter;
import crazypants.enderio.network.PacketHandler;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockAlloySmelter
extends AbstractMachineBlock<TileAlloySmelter> {
    IIcon vanillaSmeltingOn;
    IIcon vanillaSmeltingOff;
    IIcon vanillaSmeltingOnly;

    public static BlockAlloySmelter create() {
        PacketHandler.INSTANCE.registerMessage(PacketClientState.class, PacketClientState.class, PacketHandler.nextID(), Side.SERVER);
        BlockAlloySmelter ppainter = new BlockAlloySmelter();
        ppainter.init();
        return ppainter;
    }

    private BlockAlloySmelter() {
        super(ModObject.blockAlloySmelter, TileAlloySmelter.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iIconRegister) {
        super.registerBlockIcons(iIconRegister);
        this.vanillaSmeltingOn = iIconRegister.registerIcon("enderio:furnaceSmeltingOn");
        this.vanillaSmeltingOff = iIconRegister.registerIcon("enderio:furnaceSmeltingOff");
        this.vanillaSmeltingOnly = iIconRegister.registerIcon("enderio:furnaceSmeltingOnly");
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileAlloySmelter) {
            return new ContainerAlloySmelter(player.inventory, (TileAlloySmelter)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        return new GuiAlloySmelter(player.inventory, (TileAlloySmelter)te);
    }

    @Override
    protected int getGuiId() {
        return 4;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:alloySmelterFrontOn";
        }
        return "enderio:alloySmelterFront";
    }
}

