/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.api.client.render.IRenderFace;
import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.CustomCubeRenderer;
import com.enderio.core.client.render.TechneModelRenderer;
import com.enderio.core.client.render.TechneUtil;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.client.render.VertexTransformComposite;
import com.google.common.collect.ObjectArrays;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.OverlayRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TechneMachineRenderer<T extends AbstractMachineEntity>
extends TechneModelRenderer {
    private CustomCubeRenderer ccr = new CustomCubeRenderer();
    private OverlayRenderer overlay = new OverlayRenderer();

    public TechneMachineRenderer(AbstractMachineBlock<T> block, String modelPath) {
        super(EnderIO.DOMAIN, modelPath, block.getRenderType(), (VertexTransform)new VertexTransformComposite(new VertexTransform[]{new VertexRotationFacing(ForgeDirection.NORTH)}));
    }

    public TechneMachineRenderer(int renderId, String modelPath) {
        super(TechneUtil.getModel((String)EnderIO.DOMAIN, (String)modelPath), renderId, (VertexTransform)new VertexTransformComposite(new VertexTransform[]{new VertexRotationFacing(ForgeDirection.NORTH)}));
    }

    public TechneMachineRenderer<T> addTransform(VertexTransform vt) {
        this.vt = new VertexTransformComposite((VertexTransform[])ObjectArrays.concat((Object)vt, (Object[])((VertexTransformComposite)this.vt).xforms));
        return this;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.setFacingDir(ForgeDirection.SOUTH);
        super.renderInventoryBlock(block, metadata, modelId, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        AbstractMachineEntity te = (AbstractMachineEntity)world.getTileEntity(x, y, z);
        if (te != null) {
            this.setFacingDir(te.getFacingDir());
            this.overlay.setTile(te);
        }
        super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        if (renderer.overrideBlockTexture == null) {
            this.ccr.renderBlock(world, block, x, y, z, (IRenderFace)this.overlay);
        }
        return true;
    }

    protected IIcon getModelIcon(Block block, int metadata) {
        return ((AbstractMachineBlock)block).getModelIcon();
    }

    protected IIcon getModelIcon(IBlockAccess world, int x, int y, int z, Block block) {
        return this.getModelIcon(block, 0);
    }

    private void setFacingDir(ForgeDirection dir) {
        VertexRotationFacing rot = (VertexRotationFacing)((VertexTransformComposite)this.vt).xforms[0];
        rot.setRotation(dir);
    }
}

