/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;

public class PoweredTask
implements IPoweredTask {
    public static final String KEY_INPUT_STACKS = "inputsStacks";
    public static final String KEY_RECIPE = "recipeUid";
    public static final String KEY_USED_ENERGY = "usedEnergy";
    private static final String KEY_CHANCE = "chance";
    private float usedEnergy = 0.0f;
    private MachineRecipeInput[] inputs;
    private float requiredEnergy;
    private RecipeBonusType bonusType;
    private IMachineRecipe recipe;
    private float chance;

    public PoweredTask(IMachineRecipe recipe, float chance, MachineRecipeInput ... inputs) {
        this(recipe, 0.0f, chance, inputs);
    }

    protected PoweredTask(IMachineRecipe recipe, float usedEnergy, float chance, MachineRecipeInput ... inputsIn) {
        this.inputs = inputsIn;
        int numInputs = 0;
        for (int i = 0; i < inputsIn.length; ++i) {
            if (inputsIn[i] == null || inputsIn[i].item == null && inputsIn[i].fluid == null) continue;
            ++numInputs;
        }
        this.inputs = new MachineRecipeInput[numInputs];
        int index = 0;
        for (int i = 0; i < inputsIn.length; ++i) {
            if (inputsIn[i] == null) continue;
            if (inputsIn[i].item != null) {
                this.inputs[index] = new MachineRecipeInput(inputsIn[i].slotNumber, inputsIn[i].item.copy());
                ++index;
                continue;
            }
            if (inputsIn[i].fluid == null) continue;
            this.inputs[index] = new MachineRecipeInput(inputsIn[i].slotNumber, inputsIn[i].fluid.copy());
            ++index;
        }
        this.recipe = recipe;
        this.usedEnergy = usedEnergy;
        this.chance = MathHelper.clamp_float((float)chance, (float)0.0f, (float)1.0f);
        this.requiredEnergy = recipe.getEnergyRequired(inputsIn);
        this.bonusType = recipe.getBonusType(inputsIn);
    }

    @Override
    public void update(float availableEnergy) {
        this.usedEnergy += availableEnergy;
    }

    @Override
    public boolean isComplete() {
        return this.usedEnergy >= this.requiredEnergy;
    }

    @Override
    public float getProgress() {
        return MathHelper.clamp_float((float)(this.usedEnergy / this.requiredEnergy), (float)0.0f, (float)1.0f);
    }

    @Override
    public IMachineRecipe.ResultStack[] getCompletedResult() {
        return this.recipe.getCompletedResult(this.chance, this.inputs);
    }

    @Override
    public MachineRecipeInput[] getInputs() {
        return this.inputs;
    }

    public void setInputs(MachineRecipeInput[] inputs) {
        this.inputs = inputs;
    }

    @Override
    public float getRequiredEnergy() {
        return this.requiredEnergy;
    }

    public void setRequiredEnergy(float requiredEnergy) {
        this.requiredEnergy = requiredEnergy;
    }

    @Override
    public float getChance() {
        return this.chance;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    @Override
    public RecipeBonusType getBonusType() {
        return this.bonusType;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        NBTTagList inputItems = new NBTTagList();
        for (MachineRecipeInput ri : this.inputs) {
            NBTTagCompound stackRoot = new NBTTagCompound();
            ri.writeToNbt(stackRoot);
            inputItems.appendTag((NBTBase)stackRoot);
        }
        nbtRoot.setTag(KEY_INPUT_STACKS, (NBTBase)inputItems);
        nbtRoot.setString(KEY_RECIPE, this.recipe.getUid());
        nbtRoot.setFloat(KEY_USED_ENERGY, this.usedEnergy);
        nbtRoot.setFloat(KEY_CHANCE, this.chance);
    }

    public static IPoweredTask readFromNBT(NBTTagCompound nbtRoot) {
        float usedEnergy = nbtRoot.getFloat(KEY_USED_ENERGY);
        float chance = nbtRoot.getFloat(KEY_CHANCE);
        NBTTagList inputItems = (NBTTagList)nbtRoot.getTag(KEY_INPUT_STACKS);
        if (inputItems == null) {
            return null;
        }
        ArrayList<MachineRecipeInput> ins = new ArrayList<MachineRecipeInput>(3);
        for (int i = 0; i < inputItems.tagCount(); ++i) {
            NBTTagCompound stackTag = inputItems.getCompoundTagAt(i);
            MachineRecipeInput mi = MachineRecipeInput.readFromNBT(stackTag);
            ins.add(mi);
        }
        String uid = nbtRoot.getString(KEY_RECIPE);
        IMachineRecipe recipe = MachineRecipeRegistry.instance.getRecipeForUid(uid);
        if (recipe != null) {
            return new PoweredTask(recipe, usedEnergy, chance, ins.toArray(new MachineRecipeInput[ins.size()]));
        }
        return null;
    }

    @Override
    public IMachineRecipe getRecipe() {
        return this.recipe;
    }
}

