/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class MachineRecipeInput {
    public final int slotNumber;
    public final ItemStack item;
    public final FluidStack fluid;

    public static ItemStack getInputForSlot(int slot, MachineRecipeInput ... inputs) {
        for (MachineRecipeInput ri : inputs) {
            if (ri.slotNumber != slot) continue;
            return ri.item;
        }
        return null;
    }

    public static MachineRecipeInput create(int slotNumber, ItemStack item) {
        return new MachineRecipeInput(slotNumber, item);
    }

    public MachineRecipeInput(int slotNumber, ItemStack item) {
        this.slotNumber = slotNumber;
        this.item = item;
        this.fluid = null;
    }

    public MachineRecipeInput(int slotNumber, FluidStack fluid) {
        this.slotNumber = slotNumber;
        this.item = null;
        this.fluid = fluid;
    }

    public MachineRecipeInput(int slotNumber, ItemStack item, FluidStack fluid) {
        this.slotNumber = slotNumber;
        this.item = item;
        this.fluid = fluid;
    }

    public MachineRecipeInput copy() {
        if (this.isFluid()) {
            return new MachineRecipeInput(this.slotNumber, this.fluid.copy());
        }
        return new MachineRecipeInput(this.slotNumber, this.item == null ? (ItemStack)null : this.item.copy());
    }

    public static MachineRecipeInput readFromNBT(NBTTagCompound root) {
        int slotNum = root.getInteger("slotNum");
        ItemStack item = null;
        FluidStack fluid = null;
        if (root.hasKey("itemStack")) {
            NBTTagCompound stackRoot = root.getCompoundTag("itemStack");
            item = ItemStack.loadItemStackFromNBT((NBTTagCompound)stackRoot);
        } else if (root.hasKey("fluidStack")) {
            NBTTagCompound stackRoot = root.getCompoundTag("fluidStack");
            fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stackRoot);
        }
        return new MachineRecipeInput(slotNum, item, fluid);
    }

    public void writeToNbt(NBTTagCompound root) {
        if (this.item != null) {
            NBTTagCompound stackRoot = new NBTTagCompound();
            this.item.writeToNBT(stackRoot);
            root.setTag("itemStack", (NBTBase)stackRoot);
        } else if (this.fluid != null) {
            NBTTagCompound stackRoot = new NBTTagCompound();
            this.fluid.writeToNBT(stackRoot);
            root.setTag("fluidStack", (NBTBase)stackRoot);
        }
        root.setInteger("slotNum", this.slotNumber);
    }

    public boolean isFluid() {
        return this.fluid != null;
    }
}

